/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleColoredText;
import com.jetbrains.nodejs.uml.JsModuleUmlUtil;
import org.jetbrains.annotations.Nullable;

public class JsModulesUmlElementManager
extends AbstractDiagramElementManager<JSFile> {
    @Nullable
    public JSFile findInDataContext(DataContext context) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        return file != null && NodeModuleUtil.isModuleFile((PsiFile)file) ? (JSFile)file : null;
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof JSFile;
    }

    @Nullable
    public String getElementTitle(JSFile element) {
        return JsModuleUmlUtil.getModuleName(element);
    }

    @Nullable
    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof JSFile) {
            return new SimpleColoredText(JsModuleUmlUtil.getModuleName((JSFile)element), DEFAULT_TITLE_ATTR);
        }
        if (element instanceof JSNamedElement) {
            String text = ((JSNamedElement)element).getName();
            if (element instanceof JSFunction) {
                text = text + JSLookupUtilImpl.getFunctionTailText((JSFunctionItem)((JSFunction)element), (boolean)false, null);
            }
            return new SimpleColoredText(text, DEFAULT_TEXT_ATTR);
        }
        return null;
    }

    @Nullable
    public String getNodeTooltip(JSFile element) {
        return element.getVirtualFile().getPresentableUrl();
    }

    public SimpleColoredText getItemType(Object element) {
        JSType type;
        if (element instanceof PsiElement && (type = JSTypeUtils.getTypeOfElement((PsiElement)((PsiElement)element))) != null) {
            return new SimpleColoredText(type.getTypeText(JSType.TypeTextFormat.PRESENTABLE), DEFAULT_TEXT_ATTR);
        }
        return super.getItemType(element);
    }

    public Object[] getNodeItems(JSFile parent) {
        return JsModuleUmlUtil.getExportedSymbols(parent);
    }
}

