/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.markdown4j.Markdown4jProcessor;

public class MarkdownUtil {
    private static final Pattern SPLIT_BY_LINE_PATTERN = Pattern.compile("\n|\r|\r\n");
    private static final String HTML_CODE_START = "<code>";
    private static final String HTML_CODE_END = "</code>";
    private static final String FENCED_CODE_BLOCK = "```";
    private static final String INLINE_CODE_BLOCK = "``";
    private static final Markdown4jProcessor ourMarkdownProcessor = new Markdown4jProcessor();
    private static final Map<String, String> HTML_DOC_SUBSTITUTIONS = new HashMap();

    private MarkdownUtil() {
    }

    @NotNull
    public static String toHtml(@NotNull String markdownText) {
        String html;
        if (markdownText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markdownText", "com/jetbrains/nodejs/util/MarkdownUtil", "toHtml"));
        }
        String[] lines = SPLIT_BY_LINE_PATTERN.split(markdownText);
        ArrayList processedLines = ContainerUtil.newArrayListWithCapacity((int)lines.length);
        boolean isInCode = false;
        for (String line : lines) {
            String processedLine = StringUtil.trimTrailing((String)line);
            if ((processedLine = StringUtil.trimStart((String)processedLine, (String)" ")).contains(FENCED_CODE_BLOCK)) {
                isInCode = !isInCode;
            } else if (isInCode) {
                if (processedLine.startsWith(HTML_CODE_END)) {
                    processedLines.add(FENCED_CODE_BLOCK);
                    processedLine = StringUtil.trimStart((String)processedLine, (String)HTML_CODE_END);
                    isInCode = false;
                }
            } else {
                boolean codeStart = false;
                if (processedLine.endsWith(HTML_CODE_START)) {
                    codeStart = true;
                    processedLine = StringUtil.trimEnd((String)processedLine, (String)HTML_CODE_START);
                }
                processedLine = processedLine.replace("<pre>", FENCED_CODE_BLOCK).replace("</pre>", FENCED_CODE_BLOCK).replace(HTML_CODE_START, INLINE_CODE_BLOCK).replace(HTML_CODE_END, INLINE_CODE_BLOCK);
                if (codeStart) {
                    processedLines.add(processedLine);
                    processedLine = FENCED_CODE_BLOCK;
                    isInCode = true;
                }
            }
            processedLines.add(processedLine);
        }
        String normalizedMarkdown = StringUtil.join((Collection)processedLines, (String)"\n");
        try {
            html = ourMarkdownProcessor.process(normalizedMarkdown);
        }
        catch (IOException e) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/MarkdownUtil", "toHtml"));
            }
            return "";
        }
        String string = MarkdownUtil.adjustHtml(html);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/MarkdownUtil", "toHtml"));
        }
        return string;
    }

    @NotNull
    private static String adjustHtml(@NotNull String html) {
        if (html == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "html", "com/jetbrains/nodejs/util/MarkdownUtil", "adjustHtml"));
        }
        String str = html;
        for (Map.Entry<String, String> entry : HTML_DOC_SUBSTITUTIONS.entrySet()) {
            str = str.replace(entry.getKey(), entry.getValue());
        }
        String string = str.trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/MarkdownUtil", "adjustHtml"));
        }
        return string;
    }

    static {
        HTML_DOC_SUBSTITUTIONS.put("<pre><code>", "<pre>");
        HTML_DOC_SUBSTITUTIONS.put("</code></pre>", "</pre>");
        HTML_DOC_SUBSTITUTIONS.put("<em>", "<i>");
        HTML_DOC_SUBSTITUTIONS.put("</em>", "</i>");
        HTML_DOC_SUBSTITUTIONS.put("<strong>", "<b>");
        HTML_DOC_SUBSTITUTIONS.put("</strong>", "</b>");
        HTML_DOC_SUBSTITUTIONS.put(": //", "://");
        HTML_DOC_SUBSTITUTIONS.put("<br  />", "");
    }
}

