/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class NodeJsCodeLocator {
    private NodeJsCodeLocator() {
    }

    @NotNull
    public static File getBundledJsDir() {
        String jarPath = PathUtil.getJarPathForClass(NodeJsCodeLocator.class);
        if (!jarPath.endsWith(".jar")) {
            File file = new File(jarPath, "js");
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/NodeJsCodeLocator", "getBundledJsDir"));
            }
            return file;
        }
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            throw new RuntimeException("jar file cannot be null");
        }
        File pluginBaseDir = jarFile.getParentFile().getParentFile();
        File file = new File(pluginBaseDir, "js");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/NodeJsCodeLocator", "getBundledJsDir"));
        }
        return file;
    }

    @NotNull
    public static File getFileRelativeToJsDir(@NotNull String relativePath) throws IOException {
        String systemDependentRelativePath;
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/jetbrains/nodejs/util/NodeJsCodeLocator", "getFileRelativeToJsDir"));
        }
        File jsDir = NodeJsCodeLocator.getBundledJsDir();
        File file = new File(jsDir, systemDependentRelativePath = FileUtil.toSystemDependentName((String)relativePath));
        if (!file.isFile()) {
            throw new IOException("Cannot find " + relativePath);
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/NodeJsCodeLocator", "getFileRelativeToJsDir"));
        }
        return file2;
    }
}

