/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsCoffeeUtil {
    private NodeJsCoffeeUtil() {
    }

    public static boolean isCoffee(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/util/NodeJsCoffeeUtil", "isCoffee"));
        }
        VirtualFile file = NodeJsCoffeeUtil.getVirtualFile(element);
        return file != null && StringUtil.endsWith((CharSequence)file.getNameSequence(), (CharSequence)".coffee");
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/util/NodeJsCoffeeUtil", "getVirtualFile"));
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return psiFile.getOriginalFile().getVirtualFile();
    }
}

