/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.util;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import java.io.File;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePathUIUtil {
    public static TextFieldWithBrowseButton createRelativePathTextFieldAndTrackBaseDirChanges(@NotNull Project project, final @NotNull FileChooserDescriptor descriptor, @NotNull Document baseDirDocument) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/util/RelativePathUIUtil", "createRelativePathTextFieldAndTrackBaseDirChanges"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/nodejs/util/RelativePathUIUtil", "createRelativePathTextFieldAndTrackBaseDirChanges"));
        }
        if (baseDirDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirDocument", "com/jetbrains/nodejs/util/RelativePathUIUtil", "createRelativePathTextFieldAndTrackBaseDirChanges"));
        }
        final Ref doneRef = Ref.create((Object)false);
        RelativePathTextField relativePathTextField = new RelativePathTextField();
        TextFieldWithBrowseButton relativePath = new TextFieldWithBrowseButton(relativePathTextField){

            protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor) {
                if (!((Boolean)doneRef.get()).booleanValue()) {
                    super.installPathCompletion(descriptor);
                    doneRef.set((Object)true);
                }
            }
        };
        RelativePathUIUtil.trackBaseDirChanges(relativePath, baseDirDocument);
        return relativePath;
    }

    private static void trackBaseDirChanges(final @NotNull TextFieldWithBrowseButton textFieldWithBrowseButton, final @NotNull Document baseDirDocument) {
        if (textFieldWithBrowseButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFieldWithBrowseButton", "com/jetbrains/nodejs/util/RelativePathUIUtil", "trackBaseDirChanges"));
        }
        if (baseDirDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirDocument", "com/jetbrains/nodejs/util/RelativePathUIUtil", "trackBaseDirChanges"));
        }
        final Ref oldBaseDirRef = Ref.create((Object)RelativePathUIUtil.getText(baseDirDocument));
        RelativePathUIUtil.updatePathCompletion(textFieldWithBrowseButton, RelativePathUIUtil.getText(baseDirDocument));
        baseDirDocument.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String newText;
                String oldText = StringUtil.notNullize((String)((String)oldBaseDirRef.get()));
                if (!oldText.equals(newText = StringUtil.notNullize((String)RelativePathUIUtil.getText(baseDirDocument)))) {
                    RelativePathUIUtil.updatePathCompletion(textFieldWithBrowseButton, newText);
                    oldBaseDirRef.set((Object)newText);
                }
            }
        });
    }

    @NotNull
    private static String getText(@NotNull Document document) {
        String string;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/nodejs/util/RelativePathUIUtil", "getText"));
        }
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/RelativePathUIUtil", "getText"));
            }
            return "";
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/RelativePathUIUtil", "getText"));
        }
        return string;
    }

    private static void updatePathCompletion(@NotNull TextFieldWithBrowseButton textFieldWithBrowseButton, @NotNull String baseDirPath) {
        FileTextFieldImpl fileTextField;
        FileLookup.Finder finder;
        if (textFieldWithBrowseButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFieldWithBrowseButton", "com/jetbrains/nodejs/util/RelativePathUIUtil", "updatePathCompletion"));
        }
        if (baseDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirPath", "com/jetbrains/nodejs/util/RelativePathUIUtil", "updatePathCompletion"));
        }
        JTextField textField = textFieldWithBrowseButton.getTextField();
        File baseDir = new File(baseDirPath);
        if (textField instanceof RelativePathTextField) {
            RelativePathTextField relativePathTextField = (RelativePathTextField)textField;
            relativePathTextField.setBaseDir(baseDir);
        }
        if ((finder = (fileTextField = (FileTextFieldImpl)textField.getClientProperty("fileTextField")).getFinder()) instanceof LocalFsFinder) {
            LocalFsFinder localFsFinder = (LocalFsFinder)finder;
            localFsFinder.setBaseDir(baseDir);
        }
    }

    private static class RelativePathTextField
    extends JTextField {
        private File myBaseDir;

        private RelativePathTextField() {
            super(10);
        }

        private void setBaseDir(@NotNull File baseDir) {
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/util/RelativePathUIUtil$RelativePathTextField", "setBaseDir"));
            }
            this.myBaseDir = baseDir;
        }

        @Override
        public void setText(String text) {
            String refinedText = this.refineText(text);
            super.setText(refinedText);
        }

        @NotNull
        private String refineText(@Nullable String path) {
            String relativePath;
            boolean inside;
            if (path == null || path.trim().isEmpty()) {
                String string = StringUtil.notNullize((String)path);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/RelativePathUIUtil$RelativePathTextField", "refineText"));
                }
                return string;
            }
            File file = new File(path);
            if (file.isAbsolute() && this.myBaseDir != null && this.myBaseDir.isDirectory() && (inside = FileUtil.isAncestor((File)this.myBaseDir, (File)file, (boolean)true)) && (relativePath = FileUtil.getRelativePath((File)this.myBaseDir, (File)file)) != null) {
                String string = relativePath;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/RelativePathUIUtil$RelativePathTextField", "refineText"));
                }
                return string;
            }
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/RelativePathUIUtil$RelativePathTextField", "refineText"));
            }
            return string;
        }
    }
}

