/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.util.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.nodejs.util.ui.WithDisplayName;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class UIHelper {
    public static final String UNAVAILABLE = "Unavailable";

    private UIHelper() {
    }

    @NotNull
    public static JPanel createTitledLinePanel(@NotNull List<Pair<String, Component>> titledLines, int horizontalSpace, int verticalSpace) {
        if (titledLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titledLines", "com/jetbrains/nodejs/util/ui/UIHelper", "createTitledLinePanel"));
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        for (Pair<String, Component> titledLine : titledLines) {
            int top = row == 0 ? 0 : verticalSpace;
            JLabel label = new JLabel((String)titledLine.getFirst());
            panel.add((Component)label, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 0, 0, horizontalSpace), 0, 0));
            label.setLabelFor((Component)titledLine.getSecond());
            panel.add((Component)titledLine.getSecond(), new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(top, 0, 0, 0), 0, 0));
            ++row;
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/ui/UIHelper", "createTitledLinePanel"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createGrowingDownPanelWithHorizontallyStretchedComponent(@NotNull Component upperComponent) {
        if (upperComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperComponent", "com/jetbrains/nodejs/util/ui/UIHelper", "createGrowingDownPanelWithHorizontallyStretchedComponent"));
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(upperComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel empty = UIHelper.createEmptyPanel();
        panel.add((Component)empty, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/ui/UIHelper", "createGrowingDownPanelWithHorizontallyStretchedComponent"));
        }
        return jPanel;
    }

    @NotNull
    public static JPanel createEmptyPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/ui/UIHelper", "createEmptyPanel"));
        }
        return jPanel;
    }

    @NotNull
    public static ComboBox createCombobox(final @NotNull String prototypeDisplayValue, final @NotNull WithDisplayName displayNameWhenListIsEmpty) {
        if (prototypeDisplayValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototypeDisplayValue", "com/jetbrains/nodejs/util/ui/UIHelper", "createCombobox"));
        }
        if (displayNameWhenListIsEmpty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayNameWhenListIsEmpty", "com/jetbrains/nodejs/util/ui/UIHelper", "createCombobox"));
        }
        ComboBox comboBox = new ComboBox();
        comboBox.setPrototypeDisplayValue((Object)new WithDisplayName(){

            @Override
            public String getDisplayName() {
                return prototypeDisplayValue;
            }
        });
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<WithDisplayName>(){

            public void customize(JList list, WithDisplayName option, int index, boolean selected, boolean hasFocus) {
                String text = option == null ? displayNameWhenListIsEmpty.getDisplayName() : option.getDisplayName();
                this.setText(text);
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/ui/UIHelper", "createCombobox"));
        }
        return comboBox2;
    }

    @NotNull
    public static ComboBox createComboboxWithUnavailableDefaultValue() {
        ComboBox comboBox = UIHelper.createCombobox(UNAVAILABLE, new WithDisplayName(){

            @Override
            public String getDisplayName() {
                return UIHelper.UNAVAILABLE;
            }
        });
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/util/ui/UIHelper", "createComboboxWithUnavailableDefaultValue"));
        }
        return comboBox;
    }

    public static void addTabWithContentShownWhenSelected(final @NotNull JBTabbedPane tabbedPane, @NotNull String tabName, final @NotNull Component tabContent) {
        if (tabbedPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabbedPane", "com/jetbrains/nodejs/util/ui/UIHelper", "addTabWithContentShownWhenSelected"));
        }
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/jetbrains/nodejs/util/ui/UIHelper", "addTabWithContentShownWhenSelected"));
        }
        if (tabContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabContent", "com/jetbrains/nodejs/util/ui/UIHelper", "addTabWithContentShownWhenSelected"));
        }
        final JPanel tabEmptyContent = new JPanel();
        final int tabIndex = tabbedPane.getTabCount();
        tabbedPane.addTab(tabName, (Component)tabEmptyContent);
        final Runnable tabContentUpdater = new Runnable(){
            private boolean myWithEmptyContent = true;

            @Override
            public void run() {
                if (tabbedPane.getSelectedIndex() == tabIndex) {
                    if (this.myWithEmptyContent) {
                        tabbedPane.setComponentAt(tabIndex, tabContent);
                        this.myWithEmptyContent = false;
                    }
                } else if (!this.myWithEmptyContent) {
                    tabbedPane.setComponentAt(tabIndex, (Component)tabEmptyContent);
                    this.myWithEmptyContent = true;
                }
            }
        };
        UiNotifyConnector.doWhenFirstShown((JComponent)tabbedPane, () -> tabContentUpdater.run());
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                tabContentUpdater.run();
            }
        });
    }
}

