/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.View;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;

class PerforceClientImpl
implements PerforceClient {
    private final Project myProject;
    private final P4Connection myConnection;
    private Map<String, List<String>> myCachedInfo;
    private volatile List<View> myViews;
    private volatile List<String> myOptions;
    private volatile List<String> myCachedOptions;

    public PerforceClientImpl(Project project, P4Connection connection) {
        this.myProject = project;
        this.myConnection = connection;
    }

    private Map<String, List<String>> getInfo() throws VcsException {
        if (this.myCachedInfo == null || this.myCachedInfo.size() == 0) {
            this.myCachedInfo = PerforceManager.getInstance(this.myProject).getCachedInfo(this.myConnection);
        }
        return this.myCachedInfo;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceClientImpl", "getProject"));
        }
        return project;
    }

    @Override
    public String getName() throws VcsException {
        return this.getFieldValue("Client name:");
    }

    @Override
    public String getRoot() throws VcsException {
        return PerforceManager.getInstance(this.myProject).getClientRoot(this.myConnection);
    }

    @Override
    public List<View> getViews() throws VcsException {
        if (this.myViews == null) {
            Map<String, List<String>> clientSpec = PerforceManager.getInstance(this.myProject).getCachedClients(this.myConnection);
            this.myViews = PerforceClientImpl.parseViews(clientSpec);
        }
        return this.myViews;
    }

    @Override
    @NotNull
    public List<String> getOptions() throws VcsException {
        if (this.myOptions == null) {
            this.myOptions = PerforceClientImpl.extractOptions(PerforceManager.getInstance(this.myProject).getCachedClients(this.myConnection));
        }
        List<String> list = this.myOptions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceClientImpl", "getOptions"));
        }
        return list;
    }

    @Override
    @Nullable
    public List<String> getCachedOptions() {
        if (this.myCachedOptions == null) {
            try {
                Map<String, List<String>> clientSpec = PerforceManager.getInstance(this.myProject).getClientOnlyCached(this.myConnection);
                this.myCachedOptions = clientSpec == null ? null : PerforceClientImpl.extractOptions(clientSpec);
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }
        return this.myCachedOptions;
    }

    @NotNull
    private static List<String> extractOptions(@NotNull Map<String, List<String>> clientSpec) {
        if (clientSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientSpec", "org/jetbrains/idea/perforce/application/PerforceClientImpl", "extractOptions"));
        }
        List<String> list = clientSpec.get("Options:");
        if (list != null && !list.isEmpty()) {
            List list2 = StringUtil.split((String)list.get(0), (String)" ");
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceClientImpl", "extractOptions"));
            }
            return list2;
        }
        List<String> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceClientImpl", "extractOptions"));
        }
        return list3;
    }

    private static List<View> parseViews(Map<String, List<String>> clientSpec) {
        List<String> list = clientSpec.get("View:");
        ArrayList<View> result = new ArrayList<View>();
        if (list != null) {
            for (String aList : list) {
                View view = View.create((String)aList);
                if (view == null) continue;
                result.add(view);
            }
        }
        return result;
    }

    private String getFieldValue(String fieldName) throws VcsException {
        Map<String, List<String>> map = this.getInfo();
        if (map == null) {
            return null;
        }
        List<String> names = map.get(fieldName);
        if (names == null || names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    @Override
    public String getUserName() throws VcsException {
        return this.getFieldValue("User name:");
    }

    @Override
    @Nullable
    public String getServerPort() throws VcsException {
        return this.getFieldValue("Server address:");
    }

    @Override
    @Nullable
    public String getDeclaredServerPort() {
        if (this.myConnection instanceof P4ParametersConnection) {
            return ((P4ParametersConnection)this.myConnection).getParameters().getServer();
        }
        if (this.myConnection instanceof SingletonConnection) {
            return PerforceSettings.getSettings((Project)this.myProject).port;
        }
        return null;
    }
}

