/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.DefaultRepositoryLocation;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipperAdapter;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.vcsUtil.VcsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceRepositoryLocation;
import org.jetbrains.idea.perforce.changesBrowser.PerforceChangeBrowserSettings;
import org.jetbrains.idea.perforce.changesBrowser.PerforceOnlyDatesVersionFilterComponent;
import org.jetbrains.idea.perforce.changesBrowser.PerforceVersionFilterComponent;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.P4Revision;
import org.jetbrains.idea.perforce.perforce.P4WhereResult;
import org.jetbrains.idea.perforce.perforce.PerforceChangeCache;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class PerforceCommittedChangesProvider
implements CachingCommittedChangesProvider<PerforceChangeList, PerforceChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceCommittedChangesProvider");
    private final Project myProject;
    private final PerforceRunner myRunner;
    private final MyZipper myZipper;
    private final ChangeListColumn[] myColumns = new ChangeListColumn[]{ChangeListColumn.NUMBER, ChangeListColumn.DATE, ChangeListColumn.NAME, new ClientColumn(), ChangeListColumn.DESCRIPTION};
    @NonNls
    private static final String IS_OPENED_SIGNATURE = "is opened and not being changed";
    @NonNls
    private static final String IS_OPENED_SIGNATURE2 = "- is opened for edit - not changed";
    @NonNls
    private static final String MUST_BE_RESOLVED = "- must resolve";

    public PerforceCommittedChangesProvider(Project project) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(this.myProject);
        this.myZipper = new MyZipper();
    }

    @NotNull
    public PerforceChangeBrowserSettings createDefaultSettings() {
        PerforceChangeBrowserSettings perforceChangeBrowserSettings = new PerforceChangeBrowserSettings();
        if (perforceChangeBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceCommittedChangesProvider", "createDefaultSettings"));
        }
        return perforceChangeBrowserSettings;
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        return this.myZipper;
    }

    public ChangesBrowserSettingsEditor<PerforceChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        Collection<P4Connection> connections = PerforceSettings.getSettings(this.myProject).getAllConnections();
        if (connections.size() == 1) {
            return new PerforceVersionFilterComponent(this.myProject, connections.iterator().next(), showDateFilter);
        }
        return new PerforceOnlyDatesVersionFilterComponent();
    }

    public RepositoryLocation getLocationFor(FilePath root) {
        P4Connection connection = PerforceSettings.getSettings(this.myProject).getConnectionForFile(root.getIOFile());
        assert (connection != null) : "Null connection for " + root;
        String serverAddress = PerforceManager.getInstance(this.myProject).getClient(connection).getDeclaredServerPort();
        String location = serverAddress + "://" + root.getPresentableUrl();
        return PerforceRepositoryLocation.create(root, location, this.myProject);
    }

    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return this.getLocationFor(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(PerforceChangeBrowserSettings settings, RepositoryLocation location, int maxCount, AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        try {
            ArrayList changeLists = new ArrayList();
            PerforceSettings p4Settings = PerforceSettings.getSettings(this.myProject);
            if (!p4Settings.ENABLED) {
                return;
            }
            String url = ((DefaultRepositoryLocation)location).getURL();
            String client = settings.getClientFilter();
            String user = settings.getUserFilter();
            List<PerforceChangeList> changeListList = this.myRunner.getSubmittedChangeLists(client, user, P4File.create(new File(url)), settings, maxCount, p4Settings.SHOW_INTEGRATED_IN_COMMITTED_CHANGES);
            settings.filterChanges(changeLists);
            for (PerforceChangeList changeList : changeListList) {
                consumer.consume((Object)changeList);
            }
        }
        finally {
            consumer.finished();
        }
    }

    public List<PerforceChangeList> getCommittedChanges(PerforceChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        PerforceSettings p4Settings = PerforceSettings.getSettings(this.myProject);
        if (!p4Settings.ENABLED) {
            throw new VcsException("Perforce is offline");
        }
        ArrayList<PerforceChangeList> changeLists = new ArrayList<PerforceChangeList>();
        String url = ((DefaultRepositoryLocation)location).getURL();
        String client = settings.getClientFilter();
        String user = settings.getUserFilter();
        changeLists.addAll(this.myRunner.getSubmittedChangeLists(client, user, P4File.create(new File(url)), settings, maxCount, p4Settings.SHOW_INTEGRATED_IN_COMMITTED_CHANGES));
        LOG.debug("Changelists from Perforce: " + changeLists.size());
        settings.filterChanges(changeLists);
        LOG.debug("Changelists after filtering: " + changeLists.size());
        return changeLists;
    }

    public ChangeListColumn[] getColumns() {
        return this.myColumns;
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        return null;
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    public Pair<PerforceChangeList, FilePath> getOneList(VirtualFile file, VcsRevisionNumber number) throws VcsException {
        long changelistNumber;
        VirtualFile root;
        PerforceSettings p4Settings = PerforceSettings.getSettings(this.myProject);
        if (!p4Settings.ENABLED) {
            return null;
        }
        FilePath filePath = VcsUtil.getFilePath((String)file.getPath(), (boolean)false);
        if (file.isInLocalFileSystem() || !file.isValid()) {
            FilePath finalFilePath = filePath = ChangesUtil.getCommittedPath((Project)this.myProject, (FilePath)filePath);
            VirtualFile validParent = ChangesUtil.findValidParentAccurately((FilePath)finalFilePath);
            if (validParent == null) {
                return null;
            }
            root = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsRootFor(validParent);
        } else {
            root = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsRootFor(file);
        }
        if (root == null) {
            return null;
        }
        try {
            changelistNumber = Long.parseLong(number.asString());
        }
        catch (NumberFormatException e) {
            throw new VcsException((Throwable)e);
        }
        P4Connection connection = PerforceConnectionManager.getInstance(this.myProject).getConnectionForFile(root);
        if (connection == null) {
            throw new VcsException("Can not find connection for " + root.getPath());
        }
        P4File rootP4File = P4File.create(root);
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.USE_CHANGE_BEFORE_FILTER = true;
        settings.CHANGE_BEFORE = String.valueOf(changelistNumber);
        settings.USE_CHANGE_AFTER_FILTER = true;
        settings.CHANGE_AFTER = String.valueOf(changelistNumber);
        List<PerforceChangeList> changeListList = this.myRunner.getSubmittedChangeLists(null, null, rootP4File, settings, 1, p4Settings.SHOW_INTEGRATED_IN_COMMITTED_CHANGES);
        if (changeListList.isEmpty()) {
            List<PerforceChangeList> longerList = this.myRunner.getSubmittedChangeLists(null, null, rootP4File, settings, 0, true);
            for (PerforceChangeList list : longerList) {
                if (list.getNumber() != changelistNumber) continue;
                return this.correctNameIfNeeded(list, filePath, connection);
            }
            return null;
        }
        return this.correctNameIfNeeded(changeListList.get(0), filePath, connection);
    }

    public RepositoryLocation getForNonLocal(VirtualFile file) {
        return null;
    }

    public boolean supportsIncomingChanges() {
        return true;
    }

    private Pair<PerforceChangeList, FilePath> correctNameIfNeeded(PerforceChangeList changeList, @NotNull FilePath filePath, P4Connection connection) throws VcsException {
        P4Revision[] revisions;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/perforce/application/PerforceCommittedChangesProvider", "correctNameIfNeeded"));
        }
        for (Change change : changeList.getChanges()) {
            if (change.getAfterRevision() == null || !FileUtil.filesEqual((File)filePath.getIOFile(), (File)change.getAfterRevision().getFile().getIOFile())) continue;
            return Pair.create((Object)changeList, (Object)filePath);
        }
        for (P4Revision revision : revisions = this.myRunner.filelog(P4File.create(filePath), true)) {
            if (revision.getChangeNumber() != changeList.getNumber()) continue;
            P4WhereResult where = this.myRunner.where(revision.getDepotPath(), connection);
            return Pair.create((Object)changeList, (Object)VcsUtil.getFilePath((String)where.getLocal(), (boolean)false));
        }
        return Pair.create((Object)changeList, (Object)filePath);
    }

    public int getFormatVersion() {
        return 2;
    }

    public void writeChangeList(DataOutput stream, PerforceChangeList list) throws IOException {
        list.writeToStream(stream);
    }

    public PerforceChangeList readChangeList(RepositoryLocation location, DataInput stream) throws IOException {
        PerforceClient perforceClient;
        P4Connection connection;
        try {
            PerforceRepositoryLocation perforceRepositoryLocation = (PerforceRepositoryLocation)location;
            connection = perforceRepositoryLocation.getConnection();
            perforceClient = perforceRepositoryLocation.getClient();
        }
        catch (VcsException e) {
            throw new IOException(e);
        }
        return new PerforceChangeList(this.myProject, stream, connection, perforceClient, new PerforceChangeCache(this.myProject));
    }

    public boolean isMaxCountSupported() {
        return true;
    }

    public Collection<FilePath> getIncomingFiles(RepositoryLocation location) throws VcsException {
        String[] lines;
        if (!PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
            throw new VcsException("Perforce is offline");
        }
        DefaultRepositoryLocation repLocation = (DefaultRepositoryLocation)location;
        P4File file = P4File.create(new File(repLocation.getURL()));
        ExecResult result = this.myRunner.previewSync(file);
        if (result.getExitCode() != 0 || result.getStderr().length() > 0) {
            if (result.getStderr().contains("file(s) up-to-date.")) {
                return Collections.emptyList();
            }
            if (result.getStderr().contains(" - no such file(s)")) {
                return Collections.emptyList();
            }
            throw new VcsException("Error refreshing incoming changes: rc=" + result.getExitCode() + ", stderr=" + result.getStderr());
        }
        P4Connection connection = PerforceConnectionManager.getInstance(this.myProject).getConnectionForFile(file);
        if (connection == null) {
            throw new VcsException("Invalid Perforce settings for " + file.getLocalPath());
        }
        PerforceClient client = PerforceManager.getInstance(this.myProject).getClient(connection);
        PerforceManager perforceManager = PerforceManager.getInstance(this.myProject);
        String clientRoot = perforceManager.getClientRoot(connection);
        P4WhereResult p4WhereResult = this.myRunner.whereDir(file, connection);
        String depotRoot = p4WhereResult.getDepot();
        clientRoot = FilePathsHelper.convertPath((String)clientRoot);
        depotRoot = FilePathsHelper.convertPath((String)depotRoot);
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String line : lines = LineTokenizer.tokenize((CharSequence)result.getStdout(), (boolean)false)) {
            File localPath;
            int pos;
            String lineConverted = FilePathsHelper.convertPath((String)line);
            int n = pos = clientRoot == null ? -1 : lineConverted.indexOf(clientRoot);
            if (pos >= 0) {
                File localFile = new File(line.substring(pos));
                LOG.debug("Incoming file: " + line.substring(pos));
                files.add(VcsContextFactory.SERVICE.getInstance().createFilePathOn(localFile));
                continue;
            }
            if (line.contains(IS_OPENED_SIGNATURE)) {
                String depotPath;
                pos = line.indexOf(" - ");
                if (pos < 0 || (localPath = PerforceManager.getFileByDepotName(depotPath = line.substring(0, pos), client)) == null) continue;
                files.add(VcsContextFactory.SERVICE.getInstance().createFilePathOn(localPath));
                continue;
            }
            if (line.contains(IS_OPENED_SIGNATURE2)) {
                String depotPath;
                pos = line.indexOf(IS_OPENED_SIGNATURE2);
                if (pos < 0 || (localPath = PerforceManager.getFileByDepotName(depotPath = line.substring(0, pos), client)) == null) continue;
                files.add(VcsContextFactory.SERVICE.getInstance().createFilePathOn(localPath));
                continue;
            }
            if (line.contains(MUST_BE_RESOLVED)) {
                String depotPath;
                File localPath2;
                pos = lineConverted.indexOf(depotRoot);
                int pathEnd = line.indexOf(MUST_BE_RESOLVED);
                if (pos < 0 || (localPath2 = PerforceManager.getFileByDepotName(depotPath = line.substring(pos, pathEnd).trim(), client)) == null) continue;
                files.add(VcsContextFactory.SERVICE.getInstance().createFilePathOn(localPath2));
                continue;
            }
            LOG.info("Unknown line in incoming files: " + line);
        }
        return files;
    }

    public boolean refreshCacheByNumber() {
        return true;
    }

    public String getChangelistTitle() {
        return PerforceBundle.message((String)"changes.browser.changelist.term", (Object[])new Object[0]);
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, PerforceChangeList changeList) {
        return localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted() {
        return false;
    }

    private static class ClientColumn
    extends ChangeListColumn<PerforceChangeList> {
        private ClientColumn() {
        }

        public String getTitle() {
            return PerforceBundle.message((String)"changes.browser.client.column.name", (Object[])new Object[0]);
        }

        public Object getValue(PerforceChangeList changeList) {
            return changeList.getClient();
        }

        public Comparator<PerforceChangeList> getComparator() {
            return (o1, o2) -> o1.getClient().compareTo(o2.getClient());
        }
    }

    private static class MyZipper
    extends VcsCommittedListsZipperAdapter {
        private MyZipper() {
            super((VcsCommittedListsZipperAdapter.GroupCreator)new MyGroupCreator());
        }
    }

    private static class MyGroupCreator
    implements VcsCommittedListsZipperAdapter.GroupCreator {
        private MyGroupCreator() {
        }

        public Object createKey(RepositoryLocation location) {
            String url = ((DefaultRepositoryLocation)location).getLocation();
            int idx = url.indexOf("://");
            return idx == -1 ? url : url.substring(0, idx);
        }

        public RepositoryLocationGroup createGroup(Object key, Collection<RepositoryLocation> locations) {
            RepositoryLocationGroup group = new RepositoryLocationGroup(key.toString());
            for (RepositoryLocation location : locations) {
                group.add(location);
            }
            return group;
        }
    }
}

