/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import org.jetbrains.annotations.NotNull;

public class PerforceNameCommentConvertor {
    private final String myNativeDescription;
    private final String myIdeaName;
    private final String myIdeaComment;

    private PerforceNameCommentConvertor(@NotNull String nativeDescription, @NotNull String ideaName, @NotNull String ideaComment) {
        if (nativeDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeDescription", "org/jetbrains/idea/perforce/application/PerforceNameCommentConvertor", "<init>"));
        }
        if (ideaName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaName", "org/jetbrains/idea/perforce/application/PerforceNameCommentConvertor", "<init>"));
        }
        if (ideaComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaComment", "org/jetbrains/idea/perforce/application/PerforceNameCommentConvertor", "<init>"));
        }
        this.myNativeDescription = nativeDescription;
        this.myIdeaName = ideaName;
        this.myIdeaComment = ideaComment;
    }

    public static PerforceNameCommentConvertor fromNative(@NotNull String nativeDescription) {
        String comment;
        String name;
        if (nativeDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeDescription", "org/jetbrains/idea/perforce/application/PerforceNameCommentConvertor", "fromNative"));
        }
        String trimmed = nativeDescription.trim();
        int pos = trimmed.indexOf("\n");
        if (pos >= 0) {
            name = trimmed.substring(0, pos).trim() + "...";
            comment = trimmed;
        } else {
            name = trimmed;
            comment = "";
        }
        return new PerforceNameCommentConvertor(nativeDescription, name, comment);
    }

    public String getNativeDescription() {
        return this.myNativeDescription;
    }

    public String getIdeaName() {
        return this.myIdeaName;
    }

    public String getIdeaComment() {
        return this.myIdeaComment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerforceNameCommentConvertor convertor = (PerforceNameCommentConvertor)o;
        if (!this.myIdeaComment.equals(convertor.myIdeaComment)) {
            return false;
        }
        return this.myIdeaName.equals(convertor.myIdeaName);
    }

    public int hashCode() {
        int result = this.myIdeaName.hashCode();
        result = 31 * result + this.myIdeaComment.hashCode();
        return result;
    }
}

