/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.LastSuccessfulUpdateTracker;
import org.jetbrains.idea.perforce.application.PerforceChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.PerforceCachingContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public class PerforceOfflineChangeProvider
implements ChangeProvider {
    private final Project myProject;

    public PerforceOfflineChangeProvider(Project project) {
        this.myProject = project;
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyScope", "org/jetbrains/idea/perforce/application/PerforceOfflineChangeProvider", "getChanges"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/idea/perforce/application/PerforceOfflineChangeProvider", "getChanges"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "org/jetbrains/idea/perforce/application/PerforceOfflineChangeProvider", "getChanges"));
        }
        if (addGate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addGate", "org/jetbrains/idea/perforce/application/PerforceOfflineChangeProvider", "getChanges"));
        }
        builder.reportAdditionalInfo(() -> {
            HyperlinkLabel label = new HyperlinkLabel();
            label.setForeground((Color)JBColor.RED);
            label.setHyperlinkText("Perforce is offline. ", "Go online", "");
            label.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        PerforceSettings settings = PerforceSettings.getSettings(PerforceOfflineChangeProvider.this.myProject);
                        if (!settings.ENABLED) {
                            settings.enable();
                        }
                    }
                }
            });
            return label;
        });
        Set<VirtualFile> writable = PerforceChangeProvider.collectWritableFiles(dirtyScope);
        VcsOperationLog opLog = VcsOperationLog.getInstance(this.myProject);
        Map<String, String> reopenedPaths = opLog.getReopenedPaths();
        List<LastSuccessfulUpdateTracker.PersistentChangeList> changeLists = LastSuccessfulUpdateTracker.getInstance(this.myProject).getChangeLists();
        if (changeLists != null) {
            for (LastSuccessfulUpdateTracker.PersistentChangeList changeList : changeLists) {
                for (LastSuccessfulUpdateTracker.ChangedFile file : changeList.files) {
                    FilePath afterPath;
                    FilePath beforePath;
                    String changeListName = changeList.name;
                    if (file.beforePath != null && reopenedPaths.containsKey(file.beforePath)) {
                        changeListName = reopenedPaths.get(file.beforePath);
                    } else if (file.afterPath != null && reopenedPaths.containsKey(file.afterPath)) {
                        changeListName = reopenedPaths.get(file.afterPath);
                    }
                    if (changeListName == null || !PerforceOfflineChangeProvider.isInScope(dirtyScope, beforePath = PerforceOfflineChangeProvider.createFilePath(file.beforePath), afterPath = PerforceOfflineChangeProvider.createFilePath(file.afterPath))) continue;
                    ContentRevision beforeRevision = null;
                    ContentRevision afterRevision = null;
                    if (beforePath != null) {
                        beforeRevision = PerforceCachingContentRevision.createOffline(this.myProject, beforePath, afterPath != null ? afterPath : beforePath);
                    }
                    if (afterPath != null) {
                        afterRevision = CurrentContentRevision.create((FilePath)afterPath);
                        writable.remove(afterPath.getVirtualFile());
                    }
                    builder.processChangeInList(new Change(beforeRevision, afterRevision), changeListName, PerforceVcs.getKey());
                }
            }
        }
        List<VcsOperation> list = opLog.getPendingOperations();
        for (VcsOperation op : list) {
            Change c = op.getChange(this.myProject, addGate);
            if (c == null) continue;
            FilePath afterPath = ChangesUtil.getAfterPath((Change)c);
            if (!PerforceOfflineChangeProvider.isInScope(dirtyScope, ChangesUtil.getBeforePath((Change)c), afterPath)) continue;
            if (afterPath != null) {
                writable.remove(afterPath.getVirtualFile());
            }
            builder.processChangeInList(c, op.getChangeList(), PerforceVcs.getKey());
        }
        for (VirtualFile file : writable) {
            if (LastUnchangedContentTracker.hasSavedContent((VirtualFile)file)) {
                builder.processModifiedWithoutCheckout(file);
                continue;
            }
            builder.processUnversionedFile(file);
        }
    }

    private static boolean isInScope(VcsDirtyScope dirtyScope, FilePath beforePath, FilePath afterPath) {
        return beforePath != null && dirtyScope.belongsTo(beforePath) || afterPath != null && dirtyScope.belongsTo(afterPath);
    }

    @Nullable
    private static FilePath createFilePath(String beforePath) {
        if (beforePath == null) {
            return null;
        }
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(beforePath), false);
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return false;
    }

    public void doCleanup(List<VirtualFile> files) {
    }
}

