/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ColumnInfo;
import icons.PerforceIcons;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.ShowAllSubmittedFilesAction;
import org.jetbrains.idea.perforce.application.PerforceFileRevision;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.P4Revision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceVcsHistoryProvider
implements VcsHistoryProvider {
    private final PerforceVcs myVcs;
    private static final ColumnInfo<VcsFileRevision, String> REVISION = new ColumnInfo<VcsFileRevision, String>(PerforceBundle.message((String)"file.history.revision.column.name", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            if (!(vcsFileRevision instanceof PerforceFileRevision)) {
                return "";
            }
            return String.valueOf(((PerforceFileRevision)vcsFileRevision).getVersionNumber());
        }

        public Comparator<VcsFileRevision> getComparator() {
            return (r1, r2) -> {
                if (!(r1 instanceof PerforceFileRevision)) {
                    return 1;
                }
                if (!(r2 instanceof PerforceFileRevision)) {
                    return -1;
                }
                return (int)(((PerforceFileRevision)r1).getVersionNumber() - ((PerforceFileRevision)r2).getVersionNumber());
            };
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> ACTION = new ColumnInfo<VcsFileRevision, String>(PerforceBundle.message((String)"file.history.action.column.name", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            if (!(vcsFileRevision instanceof PerforceFileRevision)) {
                return "";
            }
            return ((PerforceFileRevision)vcsFileRevision).getAction();
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> CLIENT = new ColumnInfo<VcsFileRevision, String>(PerforceBundle.message((String)"file.history.client.column.name", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            if (!(vcsFileRevision instanceof PerforceFileRevision)) {
                return "";
            }
            return ((PerforceFileRevision)vcsFileRevision).getClient();
        }
    };
    private final PerforceRunner myRunner;

    public PerforceVcsHistoryProvider(PerforceVcs vcs) {
        this.myVcs = vcs;
        this.myRunner = PerforceRunner.getInstance(vcs.getProject());
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])new ColumnInfo[]{REVISION, ACTION, CLIENT});
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[]{new ShowBranchesAction(refresher), new ShowAllSubmittedFilesAction()};
    }

    public boolean isDateOmittable() {
        return false;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public VcsHistorySession createSessionFor(FilePath filePath) throws VcsException {
        filePath = ChangesUtil.getCommittedPath((Project)this.myVcs.getProject(), (FilePath)filePath);
        P4Connection connection = this.myVcs.getSettings().getConnectionForFile(filePath.getIOFile());
        if (connection == null) {
            throw new VcsException("Invalid Perforce settings");
        }
        P4File p4File = P4File.create(filePath);
        p4File.invalidateFstat();
        ArrayList<VcsFileRevision> revisions = new ArrayList<VcsFileRevision>();
        PerforceRunner runner = PerforceRunner.getInstance(this.myVcs.getProject());
        for (P4Revision p4Revision : runner.filelog(p4File, PerforceSettings.getSettings((Project)this.myVcs.getProject()).SHOW_BRANCHES_HISTORY)) {
            revisions.add(new PerforceFileRevision(p4Revision, connection, this.myVcs.getProject()));
        }
        return this.createSession(p4File, revisions, this.myRunner.getCurrentRevision(p4File));
    }

    private VcsAbstractHistorySession createSession(final P4File p4File, List<VcsFileRevision> revisions, VcsRevisionNumber currentRevisionNumber) {
        return new VcsAbstractHistorySession(revisions, currentRevisionNumber){

            @Nullable
            public VcsRevisionNumber calcCurrentRevisionNumber() {
                return PerforceVcsHistoryProvider.this.myRunner.getCurrentRevision(p4File);
            }

            public boolean isCurrentRevision(VcsRevisionNumber rev) {
                if (!(rev instanceof PerforceVcsRevisionNumber)) {
                    return false;
                }
                PerforceVcsRevisionNumber p4rev = (PerforceVcsRevisionNumber)rev;
                PerforceVcsRevisionNumber currentRev = (PerforceVcsRevisionNumber)this.getCachedRevision();
                if (currentRev != null && p4rev.getRevisionNumber() == currentRev.getRevisionNumber() && !p4rev.isBranched()) {
                    String curPath = currentRev.getDepotPath();
                    String revPath = p4rev.getDepotPath();
                    return curPath == null || revPath == null || curPath.equals(revPath);
                }
                return false;
            }

            public boolean shouldBeRefreshed() {
                VcsRevisionNumber oldValue = this.getCachedRevision();
                VcsRevisionNumber newNumber = this.calcCurrentRevisionNumber();
                if (newNumber == null) {
                    return false;
                }
                this.setCachedRevision(newNumber);
                return oldValue == null || ((PerforceVcsRevisionNumber)oldValue).getRevisionNumber() != ((PerforceVcsRevisionNumber)newNumber).getRevisionNumber();
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }

            public VcsHistorySession copy() {
                return PerforceVcsHistoryProvider.this.createSession(p4File, this.getRevisionList(), this.getCurrentRevisionNumber());
            }
        };
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VcsHistorySession session = this.createSessionFor(path);
        partner.reportCreatedEmptySession((VcsAbstractHistorySession)session);
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return null;
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/application/PerforceVcsHistoryProvider", "canShowHistoryFor"));
        }
        return true;
    }

    class ShowBranchesAction
    extends ToggleAction
    implements DumbAware {
        private final Runnable myPanelRefresher;

        public ShowBranchesAction(Runnable panelRefresher) {
            super(PerforceBundle.message((String)"action.name.show.branches", (Object[])new Object[0]), null, PerforceIcons.ShowBranches);
            this.myPanelRefresher = panelRefresher;
        }

        public boolean isSelected(AnActionEvent e) {
            return PerforceSettings.getSettings((Project)((PerforceVcsHistoryProvider)PerforceVcsHistoryProvider.this).myVcs.getProject()).SHOW_BRANCHES_HISTORY;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            PerforceSettings.getSettings((Project)((PerforceVcsHistoryProvider)PerforceVcsHistoryProvider.this).myVcs.getProject()).SHOW_BRANCHES_HISTORY = state;
            if (this.myPanelRefresher != null) {
                this.myPanelRefresher.run();
            }
        }
    }
}

