/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;

public class SplitListIntoConnections<T> {
    private final MultiMap<ConnectionKey, FilePath> myPaths = MultiMap.createSet();
    private final PerforceConnectionManagerI myConnectionManager;
    private final Convertor<P4Connection, T> myFactory;
    private final Map<ConnectionKey, T> myByConnectionMap = ContainerUtil.newHashMap();

    public SplitListIntoConnections(Project project, Convertor<P4Connection, T> factory) {
        this.myFactory = factory;
        this.myConnectionManager = PerforceConnectionManager.getInstance(project);
    }

    private void processRevision(ContentRevision contentRevision) throws VcsException {
        FilePath filePath = contentRevision.getFile();
        P4Connection connection = this.myConnectionManager.getConnectionForFile(filePath.getIOFile());
        if (connection == null) {
            return;
        }
        ConnectionKey key = connection.getConnectionKey();
        this.myPaths.putValue((Object)key, (Object)filePath);
        this.myByConnectionMap.put(key, this.myFactory.convert((Object)connection));
    }

    public void execute(Collection<Change> incomingChanges) throws VcsException {
        for (Change incomingChange : incomingChanges) {
            if (incomingChange.getBeforeRevision() != null) {
                this.processRevision(incomingChange.getBeforeRevision());
            }
            if (incomingChange.getAfterRevision() == null) continue;
            this.processRevision(incomingChange.getAfterRevision());
        }
    }

    public MultiMap<ConnectionKey, FilePath> getPaths() {
        return this.myPaths;
    }

    public Map<ConnectionKey, T> getByConnectionMap() {
        return this.myByConnectionMap;
    }
}

