/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.PerforceTimeoutException;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

class PerforceContext {
    private static final int ourVeryLongServerTimeout = 1200000;
    @NotNull
    public final P4Connection connection;
    public final boolean longTimeout;
    public final boolean justLogged;

    public PerforceContext(@NotNull P4Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/perforce/PerforceContext", "<init>"));
        }
        this(connection, false, false);
    }

    public PerforceContext(@NotNull P4Connection connection, boolean longTimeout, boolean justLogged) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/perforce/PerforceContext", "<init>"));
        }
        this.connection = connection;
        this.longTimeout = longTimeout;
        this.justLogged = justLogged;
    }

    void runP4Command(PerforceSettings settings, String[] p4args, ExecResult retVal, @Nullable StringBuffer inputStream) throws VcsException, PerforceTimeoutException, IOException, InterruptedException {
        this.connection.runP4Command(this.longTimeout ? new LongTimeoutProxy(settings) : settings, p4args, retVal, inputStream);
    }

    private static class LongTimeoutProxy
    implements PerforcePhysicalConnectionParametersI {
        private final PerforcePhysicalConnectionParametersI myDelegate;

        public LongTimeoutProxy(PerforcePhysicalConnectionParametersI delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public int getServerTimeout() {
            return this.myDelegate.getServerTimeout() <= 0 ? 1200000 : Math.max(1200000, this.myDelegate.getServerTimeout());
        }

        @Override
        @NotNull
        public String getCharsetName() {
            String string = this.myDelegate.getCharsetName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/PerforceContext$LongTimeoutProxy", "getCharsetName"));
            }
            return string;
        }

        @Override
        public String getPathToExec() {
            return this.myDelegate.getPathToExec();
        }

        @Override
        public Project getProject() {
            return this.myDelegate.getProject();
        }

        @Override
        public void disable() {
            this.myDelegate.disable();
        }
    }
}

