/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigHelper;

public class P4ConnectionParameters {
    @Nullable
    private String myServer;
    @Nullable
    private String myUser;
    @Nullable
    private String myClient;
    @Nullable
    private String myPassword;
    @Nullable
    private String myCharset;
    @Nullable
    private String myConfigFileName = P4ConfigHelper.getP4ConfigFileName();
    @Nullable
    private String myIgnoreFileName = P4ConfigHelper.getP4IgnoreFileName();
    private Throwable myException;
    private final List<String> myWarnings;
    private boolean myNoConfigFound;

    public P4ConnectionParameters() {
        this.myWarnings = new ArrayList<String>();
    }

    private P4ConnectionParameters(@Nullable String server, @Nullable String user, @Nullable String client, @Nullable String password, @Nullable String charset) {
        this.myServer = server;
        this.myUser = user;
        this.myClient = client;
        this.myPassword = password;
        this.myWarnings = new ArrayList<String>();
        this.myCharset = charset;
    }

    public P4ConnectionParameters(P4ConnectionParameters parameters) {
        this(parameters.getServer(), parameters.getUser(), parameters.getClient(), parameters.getPassword(), parameters.getCharset());
    }

    public boolean allFieldsDefined() {
        return this.myUser != null && this.myServer != null && this.myClient != null && this.myPassword != null && this.myCharset != null;
    }

    @Nullable
    public String getServer() {
        return this.myServer;
    }

    public void setServer(@Nullable String server) {
        this.myServer = server;
    }

    @Nullable
    public String getUser() {
        return this.myUser;
    }

    public void setUser(@Nullable String user) {
        this.myUser = user;
    }

    @Nullable
    public String getClient() {
        return this.myClient;
    }

    public void setClient(@Nullable String client) {
        this.myClient = client;
    }

    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    public void setPassword(@Nullable String password) {
        this.myPassword = password;
    }

    public Throwable getException() {
        return this.myException;
    }

    public void setException(Throwable exception) {
        this.myException = exception;
    }

    public boolean hasProblems() {
        return this.myException != null || !this.myWarnings.isEmpty();
    }

    public List<String> getWarnings() {
        return this.myWarnings;
    }

    public void addWarning(String warning) {
        this.myWarnings.add(warning);
    }

    @Nullable
    public String getCharset() {
        return this.myCharset;
    }

    public void setCharset(@Nullable String charset) {
        this.myCharset = charset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        P4ConnectionParameters that = (P4ConnectionParameters)o;
        if (this.myClient != null ? !this.myClient.equals(that.myClient) : that.myClient != null) {
            return false;
        }
        if (this.myPassword != null ? !this.myPassword.equals(that.myPassword) : that.myPassword != null) {
            return false;
        }
        if (this.myServer != null ? !this.myServer.equals(that.myServer) : that.myServer != null) {
            return false;
        }
        return !(this.myUser != null ? !this.myUser.equals(that.myUser) : that.myUser != null);
    }

    public int hashCode() {
        int result = this.myServer != null ? this.myServer.hashCode() : 0;
        result = 31 * result + (this.myUser != null ? this.myUser.hashCode() : 0);
        result = 31 * result + (this.myClient != null ? this.myClient.hashCode() : 0);
        result = 31 * result + (this.myPassword != null ? this.myPassword.hashCode() : 0);
        return result;
    }

    public boolean isNoConfigFound() {
        return this.myNoConfigFound;
    }

    public void setNoConfigFound(boolean noConfigFound) {
        this.myNoConfigFound = noConfigFound;
    }

    @Nullable
    public String getConfigFileName() {
        return this.myConfigFileName;
    }

    public void setConfigFileName(@Nullable String configFileName) {
        this.myConfigFileName = configFileName;
    }

    @Nullable
    public String getIgnoreFileName() {
        return this.myIgnoreFileName;
    }

    public void setIgnoreFileName(@NotNull String ignoreFileName) {
        if (ignoreFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoreFileName", "org/jetbrains/idea/perforce/perforce/connections/P4ConnectionParameters", "setIgnoreFileName"));
        }
        this.myIgnoreFileName = ignoreFileName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").omitNullValues().add("myConfigFileName", (Object)this.myConfigFileName).add("myServer", (Object)this.myServer).add("myUser", (Object)this.myUser).add("myClient", (Object)this.myClient).add("myIgnoreFileName", (Object)this.myIgnoreFileName).add("myException", (Object)this.myException).add("myWarnings", this.myWarnings).add("myNoConfigFound", this.myNoConfigFound).toString();
    }
}

