/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceTimeoutException;
import org.jetbrains.idea.perforce.perforce.connections.AbstractP4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigHelper;

public class PerforceLocalConnection
extends AbstractP4Connection {
    private final ConnectionId myConnectionId;
    private final File myCwd;

    public PerforceLocalConnection(@NotNull String workingDir) {
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "org/jetbrains/idea/perforce/perforce/connections/PerforceLocalConnection", "<init>"));
        }
        this.myCwd = new File(workingDir);
        this.myConnectionId = new ConnectionId(P4ConfigHelper.getP4ConfigFileName(), workingDir);
    }

    @Override
    public void runP4Command(PerforcePhysicalConnectionParametersI parameters, String[] p4args, ExecResult retVal, @Nullable StringBuffer inputStream) throws VcsException, PerforceTimeoutException, IOException, InterruptedException {
        this.runP4CommandImpl(parameters, ArrayUtil.EMPTY_STRING_ARRAY, p4args, retVal, inputStream, this.myCwd);
    }

    @Override
    @NotNull
    public ConnectionKey getConnectionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionId getId() {
        return this.myConnectionId;
    }

    @Override
    public boolean handlesFile(File file) {
        return true;
    }
}

