/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionMapper;

public class PerforceMultipleConnections
implements PerforceConnectionMapper {
    @Nullable
    private final String myP4ConfigValue;
    private final TreeMap<VirtualFile, P4ConnectionParameters> myParametersMap;
    private final P4ConnectionParameters myDefaultParameters;
    private final Map<VirtualFile, P4ParametersConnection> myConnectionMap = new HashMap<VirtualFile, P4ParametersConnection>();
    private final Object myLock = new Object();
    private final Map<VirtualFile, File> myConfigsMap;

    public PerforceMultipleConnections(@Nullable String p4ConfigValue, P4ConnectionParameters defaultParameters, Map<VirtualFile, P4ConnectionParameters> parametersMap, Map<VirtualFile, File> configsMap) {
        this.myP4ConfigValue = p4ConfigValue;
        this.myDefaultParameters = defaultParameters;
        this.myConfigsMap = configsMap;
        this.myParametersMap = new TreeMap(FilePathComparator.getInstance());
        this.myParametersMap.putAll(parametersMap);
    }

    public P4ConnectionParameters getDefaultParameters() {
        return this.myDefaultParameters;
    }

    @Nullable
    public String getP4ConfigValue() {
        return this.myP4ConfigValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P4ParametersConnection getConnection(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceMultipleConnections", "getConnection"));
        }
        Object object = this.myLock;
        synchronized (object) {
            P4ParametersConnection cached = this.myConnectionMap.get(file);
            if (cached != null) {
                return cached;
            }
        }
        Map.Entry<VirtualFile, P4ConnectionParameters> entry = this.myParametersMap.floorEntry(file);
        if (entry == null) {
            return null;
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            return this.createOrGetConnectionByParameters(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P4ParametersConnection createOrGetConnectionByParameters(VirtualFile vf, P4ConnectionParameters parameters) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnectionMap.containsKey(vf)) {
                return this.myConnectionMap.get(vf);
            }
            P4ConnectionParameters withParent = parameters.hasProblems() ? parameters : new P4ConnectionParameters(parameters);
            P4ParametersConnection connection = new P4ParametersConnection(withParent, new ConnectionId(this.myP4ConfigValue, vf.getPath()));
            this.myConnectionMap.put(vf, connection);
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<VirtualFile, P4Connection> getAllConnections() {
        Object object = this.myLock;
        synchronized (object) {
            for (Map.Entry<VirtualFile, P4ConnectionParameters> entry : this.myParametersMap.entrySet()) {
                this.createOrGetConnectionByParameters(entry.getKey(), entry.getValue());
            }
            return Collections.unmodifiableMap(this.myConnectionMap);
        }
    }

    public TreeMap<VirtualFile, P4ConnectionParameters> getParametersMap() {
        return this.myParametersMap;
    }

    public boolean hasAnyErrors() {
        if (this.myDefaultParameters.hasProblems()) {
            return true;
        }
        for (P4ConnectionParameters parameters : this.myParametersMap.values()) {
            if (!parameters.hasProblems()) continue;
            return true;
        }
        return false;
    }

    public Map<VirtualFile, File> getConfigsMap() {
        return this.myConfigsMap;
    }
}

