/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.jobs.AdderRemover;
import org.jetbrains.idea.perforce.perforce.jobs.JobsTablePresentation;
import org.jetbrains.idea.perforce.perforce.jobs.JobsWorker;
import org.jetbrains.idea.perforce.perforce.jobs.MemoryAdderRemover;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.WritingAdderRemover;

public class WiseAdderRemover
implements AdderRemover {
    private final AdderRemover myMemory;
    private final AdderRemover myWriting;

    public WiseAdderRemover(Project project, JobsTablePresentation presentation) {
        this.myMemory = new MemoryAdderRemover(presentation);
        this.myWriting = new WritingAdderRemover(new JobsWorker(project), presentation);
    }

    @Override
    public VcsException add(@NotNull PerforceJob job, LocalChangeList list, Project project) {
        if (job == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "job", "org/jetbrains/idea/perforce/perforce/jobs/WiseAdderRemover", "add"));
        }
        if (list.hasDefaultName()) {
            return this.myMemory.add(job, list, project);
        }
        return this.myWriting.add(job, list, project);
    }

    @Override
    public VcsException remove(@NotNull PerforceJob job, LocalChangeList list, Project project) {
        if (job == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "job", "org/jetbrains/idea/perforce/perforce/jobs/WiseAdderRemover", "remove"));
        }
        if (list.hasDefaultName()) {
            return this.myMemory.remove(job, list, project);
        }
        return this.myWriting.remove(job, list, project);
    }
}

