/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class View {
    private final String myDepotPath;
    private final String myLocalPath;
    private final String myStringRepresentation;
    private String myLocalPattern;
    private Matcher myDepotMatcher;
    private Map<Integer, Integer> myDepotPatternBackReferences;
    private List<Integer> myWildcardGroupNumbers;
    private List<Integer> myStarGroupNumbers;
    private int myDepotPatternGroupCount;

    @Nullable
    public static View create(String viewString) {
        String[] params = ParametersList.parse((String)viewString);
        List<String> strings = Arrays.asList(params);
        if (strings.size() != 2) {
            return null;
        }
        String depot = strings.get(0).trim();
        String client = strings.get(1).trim();
        return new View(depot, client, viewString);
    }

    private View(String depotPath, String localPath, String viewString) {
        this.myDepotPath = depotPath;
        this.myLocalPath = localPath;
        this.myStringRepresentation = viewString;
    }

    public String getDepotPath() {
        return this.myDepotPath;
    }

    public String getLocalPath() {
        return this.myLocalPath;
    }

    public String toString() {
        return this.myStringRepresentation;
    }

    @Nullable
    public synchronized String match(String filePath, String clientName) {
        String result = this.replaceDepotPathWithLocal(filePath);
        if (result == null) {
            return null;
        }
        result = StringUtil.trimStart((String)result, (String)"//");
        result = StringUtil.trimStart((String)result, (String)clientName);
        result = StringUtil.trimStart((String)result, (String)"/");
        return result;
    }

    public boolean removeMatched() {
        return this.getDepotPath().startsWith("-");
    }

    @Nullable
    public static String getRelativePath(String filePath, String clientName, List<View> views) {
        String result = null;
        for (View view : views) {
            String localResult;
            if (clientName == null || (localResult = view.match(filePath, clientName)) == null) continue;
            if (view.removeMatched()) {
                result = null;
                continue;
            }
            result = localResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processStringWithReferences(String stringWithReferences, ReferenceVisitor visitor) {
        int offset = 0;
        int refIndex = stringWithReferences.indexOf("%%", offset);
        int wildcardIndex = stringWithReferences.indexOf("\\.\\.\\.", offset);
        int starIndex = stringWithReferences.indexOf(".*", offset);
        while (refIndex >= 0 && stringWithReferences.length() > refIndex + 2 || wildcardIndex >= 0 || starIndex >= 0) {
            if (View.existsAndBefore(refIndex, wildcardIndex, starIndex)) {
                if (refIndex > offset) {
                    visitor.visitStringFragment(stringWithReferences.subSequence(offset, refIndex));
                }
                String referenceName = stringWithReferences.substring(refIndex + 2, refIndex + 3);
                try {
                    visitor.visitNextReference(Integer.parseInt(referenceName));
                }
                finally {
                    offset = refIndex + 3;
                }
                refIndex = stringWithReferences.indexOf("%%", offset);
                continue;
            }
            if (View.existsAndBefore(starIndex, wildcardIndex)) {
                if (starIndex > offset) {
                    visitor.visitStringFragment(stringWithReferences.subSequence(offset, starIndex));
                }
                try {
                    visitor.visitStar();
                }
                finally {
                    offset = starIndex + 2;
                }
                starIndex = stringWithReferences.indexOf(".*", offset);
                continue;
            }
            if (wildcardIndex > offset) {
                visitor.visitStringFragment(stringWithReferences.subSequence(offset, wildcardIndex));
            }
            try {
                visitor.visitWildcard();
            }
            finally {
                offset = wildcardIndex + 6;
            }
            wildcardIndex = stringWithReferences.indexOf("\\.\\.\\.", offset);
        }
        if (offset < stringWithReferences.length()) {
            visitor.visitStringFragment(stringWithReferences.subSequence(offset, stringWithReferences.length()));
        }
    }

    private static boolean existsAndBefore(int index, int ... otherIndices) {
        if (index == -1) {
            return false;
        }
        for (int otherIdx : otherIndices) {
            if (otherIdx >= index || otherIdx == -1) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private String replaceDepotPathWithLocal(String filePath) {
        Matcher matcher = this.getMatcher(filePath);
        if (matcher.matches()) {
            return matcher.replaceFirst(this.convertLocalPathToReplacement(this.myDepotPatternBackReferences));
        }
        return null;
    }

    private Matcher getMatcher(String filePath) {
        if (this.myDepotMatcher == null) {
            String depotPath = this.getDepotPath();
            if (depotPath.startsWith("+") || depotPath.startsWith("-")) {
                depotPath = depotPath.substring(1);
            }
            String depotPattern = PatternUtil.convertToRegex((String)depotPath);
            this.myDepotPatternBackReferences = new HashMap();
            this.myWildcardGroupNumbers = new ArrayList<Integer>();
            this.myStarGroupNumbers = new ArrayList<Integer>();
            this.myDepotPatternGroupCount = 1;
            final StringBuffer patternWithReferences = new StringBuffer();
            View.processStringWithReferences(depotPattern, new ReferenceVisitor(){

                @Override
                public void visitWildcard() {
                    this.visitGroup("(.*)", View.this.myWildcardGroupNumbers);
                }

                @Override
                public void visitStar() {
                    this.visitGroup("([^/]+)", View.this.myStarGroupNumbers);
                }

                private void visitGroup(String patternToAdd, List<Integer> groupNumbersCollection) {
                    patternWithReferences.append(patternToAdd);
                    groupNumbersCollection.add(View.this.myDepotPatternGroupCount);
                    View.this.myDepotPatternGroupCount++;
                }

                @Override
                public void visitNextReference(int referenceNum) {
                    patternWithReferences.append("(.*)");
                    View.this.myDepotPatternBackReferences.put(referenceNum, View.this.myDepotPatternGroupCount);
                    View.this.myDepotPatternGroupCount++;
                }

                @Override
                public void visitStringFragment(CharSequence string) {
                    patternWithReferences.append(string.toString());
                }
            });
            depotPattern = patternWithReferences.toString();
            Pattern pattern = Pattern.compile(depotPattern, 2);
            this.myDepotMatcher = pattern.matcher(filePath);
            return this.myDepotMatcher;
        }
        this.myDepotMatcher.reset(filePath);
        return this.myDepotMatcher;
    }

    private String convertLocalPathToReplacement(Map<Integer, Integer> backReferences) {
        StringBuffer result = new StringBuffer();
        View.processStringWithReferences(this.getLocalPattern(), new MyReferenceVisitor(result, backReferences));
        return result.toString();
    }

    private String getLocalPattern() {
        if (this.myLocalPattern == null) {
            this.myLocalPattern = PatternUtil.convertToRegex((String)this.getLocalPath());
        }
        return this.myLocalPattern;
    }

    private class MyReferenceVisitor
    implements ReferenceVisitor {
        private final StringBuffer myResult;
        private final Map<Integer, Integer> myBackReferences;
        private int myLastWildcardGroup = 0;
        private int myLastStarGroup = 0;

        public MyReferenceVisitor(StringBuffer result, Map<Integer, Integer> backReferences) {
            this.myResult = result;
            this.myBackReferences = backReferences;
        }

        @Override
        public void visitWildcard() {
            this.myLastWildcardGroup = this.visitGroup(this.myLastWildcardGroup, View.this.myWildcardGroupNumbers);
        }

        @Override
        public void visitStar() {
            this.myLastStarGroup = this.visitGroup(this.myLastStarGroup, View.this.myStarGroupNumbers);
        }

        private int visitGroup(int counter, List<Integer> groupNumbers) {
            if (counter < groupNumbers.size()) {
                this.myResult.append("$").append(String.valueOf(groupNumbers.get(counter)));
                return counter + 1;
            }
            return counter;
        }

        @Override
        public void visitNextReference(int referenceNum) {
            Integer refGroupNum = this.myBackReferences.get(referenceNum);
            if (refGroupNum != null) {
                this.myResult.append("$");
                this.myResult.append(refGroupNum);
            } else {
                this.myResult.append("%%");
                this.myResult.append(referenceNum);
            }
        }

        @Override
        public void visitStringFragment(CharSequence string) {
            this.myResult.append(string.toString());
        }
    }

    static interface ReferenceVisitor {
        public void visitNextReference(int var1);

        public void visitStringFragment(CharSequence var1);

        public void visitWildcard();

        public void visitStar();
    }
}

