/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.AuthFormKt;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.git.GitCredentialKt;
import org.jetbrains.settingsRepository.git.JGitCredentialsProviderKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J*\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0018\"\u00020\u0013H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\nH\u0016J!\u0010\u001d\u001a\u00020\u000e2\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0018\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001eRN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/settingsRepository/git/JGitCredentialsProvider;", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "credentialsStore", "Lkotlin/Lazy;", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "(Lkotlin/Lazy;Lorg/eclipse/jgit/lib/Repository;)V", "credentialsFromGit", "Lcom/google/common/cache/LoadingCache;", "Lorg/eclipse/jgit/transport/URIish;", "kotlin.jvm.PlatformType", "Lcom/intellij/credentialStore/Credentials;", "doGet", "", "uri", "userNameItem", "Lorg/eclipse/jgit/transport/CredentialItem$Username;", "passwordItem", "Lorg/eclipse/jgit/transport/CredentialItem;", "sshKeyFile", "", "get", "items", "", "(Lorg/eclipse/jgit/transport/URIish;[Lorg/eclipse/jgit/transport/CredentialItem;)Z", "isInteractive", "reset", "", "supports", "([Lorg/eclipse/jgit/transport/CredentialItem;)Z", "settings-repository"})
public final class JGitCredentialsProvider
extends CredentialsProvider {
    private final LoadingCache<URIish, Credentials> credentialsFromGit;
    private final Lazy<IcsCredentialsStore> credentialsStore;
    private final Repository repository;

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        for (int j = 0; j < items.length; ++j) {
            CredentialItem item = items[j];
            if (item instanceof CredentialItem.Password || item instanceof CredentialItem.Username || item instanceof CredentialItem.StringType || item instanceof CredentialItem.YesNoType) continue;
            return false;
        }
        return true;
    }

    public boolean get(@NotNull URIish uri, CredentialItem ... items) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        CredentialItem.Username userNameItem = null;
        CredentialItem passwordItem = null;
        String sshKeyFile = null;
        for (int j = 0; j < items.length; ++j) {
            CredentialItem item = items[j];
            if (item instanceof CredentialItem.Username) {
                userNameItem = (CredentialItem.Username)item;
                continue;
            }
            if (item instanceof CredentialItem.Password) {
                passwordItem = item;
                continue;
            }
            if (item instanceof CredentialItem.StringType) {
                String marker;
                String promptText = ((CredentialItem.StringType)item).getPromptText();
                if (promptText == null || !StringsKt.startsWith$default((String)promptText, (String)(marker = "Passphrase for "), (boolean)false, (int)2, null)) continue;
                String string = promptText;
                int n = marker.length();
                Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                passwordItem = item;
                continue;
            }
            if (!(item instanceof CredentialItem.YesNoType)) continue;
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(item){
                final /* synthetic */ CredentialItem $item;

                public final void run() {
                    CredentialItem.YesNoType yesNoType = (CredentialItem.YesNoType)this.$item;
                    String string = ((CredentialItem.YesNoType)this.$item).getPromptText();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    yesNoType.setValue(MessageDialogBuilder.yesNo((String)"", (String)string).show() == 0);
                }
                {
                    this.$item = credentialItem;
                }
            });
            return true;
        }
        if (userNameItem == null && passwordItem == null) {
            return false;
        }
        return this.doGet(uri, userNameItem, passwordItem, sshKeyFile);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doGet(URIish uri, CredentialItem.Username userNameItem, CredentialItem passwordItem, String sshKeyFile) {
        void credentials;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        String userFromUri = sshKeyFile == null ? StringKt.nullize$default((String)uri.getUser(), (boolean)false, (int)1, null) : null;
        String passwordFromUri = StringKt.nullize$default((String)uri.getPass(), (boolean)false, (int)1, null);
        if (userFromUri != null && passwordFromUri != null) {
            credentials.element = new Credentials(userFromUri, passwordFromUri);
        } else {
            boolean asWarning$iv;
            boolean bl = false;
            boolean bl2 = true;
            Object var10_10 = null;
            if (bl2 & true) {
                asWarning$iv = false;
            }
            try {
                credentials.element = ((IcsCredentialsStore)this.credentialsStore.getValue()).get(uri.getHost(), sshKeyFile, userFromUri);
                if (!(CredentialAttributesKt.isFulfilled((Credentials)((Credentials)credentials.element)) || sshKeyFile != null && MacOsKeychainLibraryKt.isMacOsCredentialStoreSupported())) {
                    credentials.element = (Credentials)this.credentialsFromGit.get((Object)uri);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e$iv) {
                if (asWarning$iv || e$iv instanceof AuthenticationException || e$iv instanceof NoRemoteRepositoryException) {
                    IcsManagerKt.getLOG().warn(e$iv);
                }
                IcsManagerKt.getLOG().error(e$iv);
            }
        }
        if (!CredentialAttributesKt.isFulfilled((Credentials)((Credentials)credentials.element))) {
            credentials.element = AuthFormKt.showAuthenticationForm((Credentials)credentials.element, JGitCredentialsProviderKt.access$toStringWithoutCredentials(uri), uri.getHost(), uri.getPath(), sshKeyFile);
            if (CredentialAttributesKt.isFulfilled((Credentials)((Credentials)credentials.element))) {
                ((IcsCredentialsStore)this.credentialsStore.getValue()).set(uri.getHost(), sshKeyFile, (Credentials)credentials.element);
            }
        }
        CredentialItem.Username username = userNameItem;
        if (username != null) {
            Credentials credentials2 = (Credentials)credentials.element;
            username.setValue(credentials2 != null ? credentials2.getUserName() : null);
        }
        if (passwordItem != null) {
            if (passwordItem instanceof CredentialItem.Password) {
                Credentials credentials3 = (Credentials)credentials.element;
                ((CredentialItem.Password)passwordItem).setValue(credentials3 != null && (credentials3 = credentials3.getPassword()) != null ? OneTimeString.toCharArray$default((OneTimeString)credentials3, (boolean)false, (int)1, null) : null);
            } else {
                Credentials credentials4 = (Credentials)credentials.element;
                ((CredentialItem.StringType)passwordItem).setValue(credentials4 != null && (credentials4 = credentials4.getPassword()) != null ? credentials4.toString() : null);
            }
        }
        return CredentialAttributesKt.isFulfilled((Credentials)((Credentials)credentials.element));
    }

    public void reset(@NotNull URIish uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.credentialsFromGit.invalidate((Object)uri);
        this.credentialsFromGit.cleanUp();
        IcsCredentialsStore icsCredentialsStore = (IcsCredentialsStore)this.credentialsStore.getValue();
        String string = uri.getHost();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        icsCredentialsStore.set(string, null, null);
    }

    public JGitCredentialsProvider(@NotNull Lazy<IcsCredentialsStore> credentialsStore2, @NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull(credentialsStore2, (String)"credentialsStore");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        this.credentialsStore = credentialsStore2;
        this.repository = repository2;
        this.credentialsFromGit = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<URIish, Credentials>(this){
            final /* synthetic */ JGitCredentialsProvider this$0;

            @NotNull
            public Credentials load(@NotNull URIish it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Credentials credentials = GitCredentialKt.getCredentialsUsingGit(it, JGitCredentialsProvider.access$getRepository$p(this.this$0));
                if (credentials == null) {
                    credentials = new Credentials(null, null, 2, null);
                }
                return credentials;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public static final /* synthetic */ Repository access$getRepository$p(JGitCredentialsProvider $this) {
        return $this.repository;
    }
}

