/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LineSeparator {
    LF("\n"),
    CRLF("\r\n"),
    CR("\r");

    private static final Logger LOG;
    private final String mySeparatorString;
    private final byte[] myBytes;

    private LineSeparator(String separatorString) {
        if (separatorString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorString", "com/intellij/util/LineSeparator", "<init>"));
        }
        this.mySeparatorString = separatorString;
        this.myBytes = separatorString.getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    @NotNull
    public static LineSeparator fromString(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/util/LineSeparator", "fromString"));
        }
        for (LineSeparator separator : LineSeparator.values()) {
            if (!separator.getSeparatorString().equals(string)) continue;
            LineSeparator lineSeparator = separator;
            if (lineSeparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LineSeparator", "fromString"));
            }
            return lineSeparator;
        }
        LOG.error("Invalid string for line separator: " + StringUtil.escapeStringCharacters(string));
        LineSeparator lineSeparator = LineSeparator.getSystemLineSeparator();
        if (lineSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LineSeparator", "fromString"));
        }
        return lineSeparator;
    }

    @NotNull
    public String getSeparatorString() {
        String string = this.mySeparatorString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LineSeparator", "getSeparatorString"));
        }
        return string;
    }

    @NotNull
    public byte[] getSeparatorBytes() {
        if (this.myBytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LineSeparator", "getSeparatorBytes"));
        }
        return this.myBytes;
    }

    public static boolean knownAndDifferent(@Nullable LineSeparator separator1, @Nullable LineSeparator separator2) {
        return separator1 != null && separator2 != null && !separator1.equals((Object)separator2);
    }

    @NotNull
    public static LineSeparator getSystemLineSeparator() {
        if (SystemInfo.isWindows) {
            LineSeparator lineSeparator = CRLF;
            if (lineSeparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LineSeparator", "getSystemLineSeparator"));
            }
            return lineSeparator;
        }
        LineSeparator lineSeparator = LF;
        if (lineSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LineSeparator", "getSystemLineSeparator"));
        }
        return lineSeparator;
    }

    static {
        LOG = Logger.getInstance(LineSeparator.class);
    }
}

