/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;

public class Range<T extends Comparable<T>> {
    @NotNull
    private final T myFrom;
    @NotNull
    private final T myTo;

    public Range(@NotNull T from, @NotNull T to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/util/Range", "<init>"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/Range", "<init>"));
        }
        this.myFrom = from;
        this.myTo = to;
    }

    public boolean isWithin(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/Range", "isWithin"));
        }
        return object.compareTo(this.myFrom) >= 0 && object.compareTo(this.myTo) <= 0;
    }

    @NotNull
    public T getFrom() {
        T t = this.myFrom;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Range", "getFrom"));
        }
        return t;
    }

    @NotNull
    public T getTo() {
        T t = this.myTo;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Range", "getTo"));
        }
        return t;
    }

    public String toString() {
        return "(" + this.myFrom + "," + this.myTo + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (!this.myFrom.equals(range.myFrom)) {
            return false;
        }
        return this.myTo.equals(range.myTo);
    }

    public int hashCode() {
        int result = this.myFrom.hashCode();
        result = 31 * result + this.myTo.hashCode();
        return result;
    }
}

