/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.ui.EdtInvocationManager;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class EdtExecutorService
extends AbstractExecutorService {
    private static final ExecutorService INSTANCE = new EdtExecutorService();
    private static final ScheduledExecutorService SCHEDULED_INSTANCE = new SchedulingWrapper(INSTANCE, ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).delayQueue){

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list = AppScheduledExecutorService.error();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/EdtExecutorService$1", "shutdownNow"));
            }
            return list;
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/EdtExecutorService$1", "awaitTermination"));
            }
            AppScheduledExecutorService.error();
            return false;
        }
    };

    @NotNull
    public static ExecutorService getInstance() {
        ExecutorService executorService = INSTANCE;
        if (executorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/EdtExecutorService", "getInstance"));
        }
        return executorService;
    }

    @NotNull
    public static ScheduledExecutorService getScheduledExecutorInstance() {
        ScheduledExecutorService scheduledExecutorService = SCHEDULED_INSTANCE;
        if (scheduledExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/EdtExecutorService", "getScheduledExecutorInstance"));
        }
        return scheduledExecutorService;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/util/concurrency/EdtExecutorService", "execute"));
        }
        EdtInvocationManager.getInstance().invokeLater(command);
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = AppScheduledExecutorService.error();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/EdtExecutorService", "shutdownNow"));
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/EdtExecutorService", "awaitTermination"));
        }
        AppScheduledExecutorService.error();
        return false;
    }
}

