/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.SingletonIteratorBase;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartHashSet<T>
extends THashSet<T> {
    private T theElement;

    public SmartHashSet() {
    }

    public SmartHashSet(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/SmartHashSet", "<init>"));
        }
        super(strategy);
    }

    public SmartHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public SmartHashSet(int initialCapacity, TObjectHashingStrategy<T> strategy) {
        super(initialCapacity, strategy);
    }

    public SmartHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SmartHashSet(int initialCapacity, float loadFactor, TObjectHashingStrategy<T> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public SmartHashSet(Collection<? extends T> collection) {
        super(collection);
    }

    public SmartHashSet(Collection<? extends T> collection, TObjectHashingStrategy<T> strategy) {
        super(collection, strategy);
    }

    public boolean contains(@NotNull Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/util/containers/SmartHashSet", "contains"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            return this.eq(theElement, obj);
        }
        return !super.isEmpty() && super.contains(obj);
    }

    public boolean add(@NotNull T obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/util/containers/SmartHashSet", "add"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            if (this.eq(theElement, obj)) {
                return false;
            }
            super.add(theElement);
            this.theElement = null;
        } else if (super.isEmpty()) {
            this.theElement = obj;
            return true;
        }
        return super.add(obj);
    }

    private boolean eq(T obj, T theElement) {
        return theElement == obj || this._hashingStrategy.equals(theElement, obj);
    }

    public boolean equals(@Nullable Object other) {
        T theElement = this.theElement;
        if (theElement != null) {
            return other instanceof Set && ((Set)other).size() == 1 && this.eq(theElement, ((Set)other).iterator().next());
        }
        return super.equals(other);
    }

    public int hashCode() {
        T theElement = this.theElement;
        if (theElement != null) {
            return this._hashingStrategy.computeHashCode(theElement);
        }
        return super.hashCode();
    }

    public void clear() {
        this.theElement = null;
        super.clear();
    }

    public int size() {
        T theElement = this.theElement;
        if (theElement != null) {
            return 1;
        }
        return super.size();
    }

    public boolean isEmpty() {
        T theElement = this.theElement;
        return theElement == null && super.isEmpty();
    }

    public boolean remove(@NotNull Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/util/containers/SmartHashSet", "remove"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            if (this.eq(theElement, obj)) {
                this.theElement = null;
                return true;
            }
            return false;
        }
        return super.remove(obj);
    }

    @NotNull
    public Iterator<T> iterator() {
        if (this.theElement != null) {
            SingletonIteratorBase singletonIteratorBase = new SingletonIteratorBase<T>(){

                @Override
                protected void checkCoModification() {
                    if (SmartHashSet.this.theElement == null) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                protected T getElement() {
                    return SmartHashSet.this.theElement;
                }

                @Override
                public void remove() {
                    this.checkCoModification();
                    SmartHashSet.this.clear();
                }
            };
            if (singletonIteratorBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SmartHashSet", "iterator"));
            }
            return singletonIteratorBase;
        }
        Iterator iterator = super.iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SmartHashSet", "iterator"));
        }
        return iterator;
    }

    public boolean forEach(@NotNull TObjectProcedure<T> procedure) {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/util/containers/SmartHashSet", "forEach"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            return procedure.execute(theElement);
        }
        return super.forEach(procedure);
    }

    @NotNull
    public Object[] toArray() {
        T theElement = this.theElement;
        if (theElement != null) {
            Object[] objectArray = new Object[]{theElement};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SmartHashSet", "toArray"));
            }
            return objectArray;
        }
        Object[] objectArray = super.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SmartHashSet", "toArray"));
        }
        return objectArray;
    }

    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/SmartHashSet", "toArray"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            if (a.length == 0) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            }
            a[0] = theElement;
            if (a.length > 1) {
                a[1] = null;
            }
            if (a == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SmartHashSet", "toArray"));
            }
            return a;
        }
        Object[] objectArray = super.toArray(a);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SmartHashSet", "toArray"));
        }
        return objectArray;
    }
}

