/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyIcon
extends JBUI.CachingScalableJBIcon<EmptyIcon> {
    private static final Map<Integer, EmptyIcon> cache = new HashMap<Integer, EmptyIcon>();
    public static final Icon ICON_16 = JBUI.scale(EmptyIcon.create(16));
    public static final Icon ICON_18 = JBUI.scale(EmptyIcon.create(18));
    public static final Icon ICON_8 = JBUI.scale(EmptyIcon.create(8));
    public static final Icon ICON_0 = JBUI.scale(EmptyIcon.create(0));
    protected final int width;
    protected final int height;
    private final boolean myUseCache;

    public static EmptyIcon create(int size) {
        return EmptyIcon.create(size, size);
    }

    public static EmptyIcon create(int width, int height) {
        return EmptyIcon.create(width, height, true);
    }

    public static EmptyIcon create(@NotNull Icon base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/util/ui/EmptyIcon", "create"));
        }
        return EmptyIcon.create(base.getIconWidth(), base.getIconHeight());
    }

    public EmptyIcon(int size) {
        this(size, size);
    }

    public EmptyIcon(int width, int height) {
        this(width, height, false);
    }

    private EmptyIcon(int width, int height, boolean useCache) {
        this.width = width;
        this.height = height;
        this.myUseCache = useCache;
    }

    protected EmptyIcon(EmptyIcon icon) {
        super(icon);
        this.width = icon.width;
        this.height = icon.height;
        this.myUseCache = icon.myUseCache;
    }

    @Override
    @NotNull
    protected EmptyIcon copy() {
        EmptyIcon emptyIcon = new EmptyIcon(this);
        if (emptyIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/EmptyIcon", "copy"));
        }
        return emptyIcon;
    }

    @Override
    public EmptyIcon withJBUIPreScaled(boolean preScaled) {
        if (this.myUseCache && this.isJBUIPreScaled() != preScaled) {
            Integer key = EmptyIcon.key(this.width, this.height);
            if (key != null) {
                cache.remove(key);
            }
            return EmptyIcon.create(this.width, this.height, preScaled);
        }
        return (EmptyIcon)super.withJBUIPreScaled(preScaled);
    }

    private static EmptyIcon create(int width, int height, boolean preScaled) {
        EmptyIcon icon;
        Integer key = EmptyIcon.key(width, height);
        EmptyIcon emptyIcon = icon = key != null ? cache.get(key) : null;
        if (icon == null) {
            icon = new EmptyIcon(width, height, true);
            icon.setJBUIPreScaled(preScaled);
            if (key != null) {
                cache.put(key, icon);
            }
        }
        return icon;
    }

    @Nullable
    private static Integer key(int width, int height) {
        return width == height && width < 129 ? Integer.valueOf(width) : null;
    }

    @Override
    public int getIconWidth() {
        return this.scaleVal(this.width);
    }

    @Override
    public int getIconHeight() {
        return this.scaleVal(this.height);
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmptyIcon)) {
            return false;
        }
        EmptyIcon icon = (EmptyIcon)o;
        if (this.scaleVal(this.height, JBUI.ScalableJBIcon.Scale.EFFECTIVE) != icon.scaleVal(icon.height, JBUI.ScalableJBIcon.Scale.EFFECTIVE)) {
            return false;
        }
        return this.scaleVal(this.width, JBUI.ScalableJBIcon.Scale.EFFECTIVE) == icon.scaleVal(icon.width, JBUI.ScalableJBIcon.Scale.EFFECTIVE);
    }

    public int hashCode() {
        int result = this.scaleVal(this.width, JBUI.ScalableJBIcon.Scale.EFFECTIVE);
        result = 31 * result + this.scaleVal(this.height, JBUI.ScalableJBIcon.Scale.EFFECTIVE);
        return result;
    }

    public EmptyIconUIResource asUIResource() {
        return new EmptyIconUIResource(this);
    }

    static {
        JBUI.addPropertyChangeListener("JBUI.userScaleFactor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                cache.clear();
            }
        });
    }

    public static class EmptyIconUIResource
    extends EmptyIcon
    implements UIResource {
        protected EmptyIconUIResource(EmptyIcon icon) {
            super(icon);
        }

        @Override
        @NotNull
        protected EmptyIconUIResource copy() {
            EmptyIconUIResource emptyIconUIResource = new EmptyIconUIResource(this);
            if (emptyIconUIResource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/EmptyIcon$EmptyIconUIResource", "copy"));
            }
            return emptyIconUIResource;
        }
    }
}

