/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompactCollectionBinding
extends NotNullDeserializeBinding {
    private final String name;

    protected CompactCollectionBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/CompactCollectionBinding", "<init>"));
        }
        super(accessor);
        this.name = this.myAccessor.getName();
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/CompactCollectionBinding", "serialize"));
        }
        Element result = new Element(this.name);
        List list = (List)o;
        if (list.isEmpty()) {
            return result;
        }
        for (String item : list) {
            result.addContent(new Element("item").setAttribute("value", item));
        }
        return result;
    }

    @Override
    @NotNull
    public Object deserialize(Object context, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/CompactCollectionBinding", "deserialize"));
        }
        List list = (List)context;
        list.clear();
        if (element.getName().equals(this.name)) {
            for (Element item : element.getChildren("item")) {
                ContainerUtil.addIfNotNull(list, item.getAttributeValue("value"));
            }
        } else {
            Element value = element.getChild("value");
            if (value != null) {
                value = value.getChild("list");
            }
            if (value != null) {
                for (Element item : value.getChildren("item")) {
                    ContainerUtil.addIfNotNull(list, item.getAttributeValue("itemvalue"));
                }
            }
        }
        List list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/CompactCollectionBinding", "deserialize"));
        }
        return list2;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/CompactCollectionBinding", "isBoundTo"));
        }
        String elementName = element.getName();
        if (this.isNameEqual(elementName)) {
            return true;
        }
        if (elementName.equals("option")) {
            return this.isNameEqual(element.getAttributeValue("name"));
        }
        return false;
    }

    private boolean isNameEqual(@Nullable String value) {
        if (value == null) {
            return false;
        }
        if (value.equals(this.name)) {
            return true;
        }
        if (value.length() == this.name.length() + 2 && value.startsWith("my")) {
            return Character.isUpperCase(value.charAt(2)) && value.regionMatches(true, 2, this.name, 0, this.name.length());
        }
        return false;
    }
}

