/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.css;

import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.webcomponents.util.WebComponentsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolymerCssDescriptorProvider
extends CssElementDescriptorProvider {
    private static final String[] POLYFILL_SELECTORS = new String[]{"polyfill-next-selector", "polyfill-rule", "polyfill-unscoped-rule"};

    public boolean isMyContext(@Nullable PsiElement context) {
        if (context == null || !context.isValid()) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        CssDialect mapping = (CssDialect)CssDialectMappings.getInstance((Project)context.getProject()).getMapping(virtualFile);
        return (mapping == null || mapping == CssDialect.CLASSIC) && WebComponentsUtil.hasPolymerJs(context);
    }

    @NotNull
    public String[] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/webcomponents/css/PolymerCssDescriptorProvider", "getSimpleSelectors"));
        }
        if (POLYFILL_SELECTORS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/css/PolymerCssDescriptorProvider", "getSimpleSelectors"));
        }
        return POLYFILL_SELECTORS;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/webcomponents/css/PolymerCssDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/css/PolymerCssDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        return PsiElement.EMPTY_ARRAY;
    }
}

