/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.css;

import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.webcomponents.index.WebComponentsIndex;
import com.intellij.webcomponents.util.WebComponentsUtil;
import com.intellij.xml.util.HtmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebComponentCssElementDescriptorProvider
extends CssElementDescriptorProvider {
    public boolean isMyContext(@Nullable PsiElement context) {
        if (context == null || !context.isValid()) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return false;
        }
        if (HtmlUtil.hasHtml((PsiFile)file)) {
            return true;
        }
        Project project = context.getProject();
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        CssDialect mapping = (CssDialect)CssDialectMappings.getInstance((Project)project).getMapping(virtualFile);
        return mapping == null || mapping == CssDialect.CLASSIC;
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider", "isPossibleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider", "isPossibleSelector"));
        }
        return WebComponentsUtil.isPossibleSelector(selector, context);
    }

    @NotNull
    public String[] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider", "getSimpleSelectors"));
        }
        if (!(CssUtil.isInsideKeyframes((PsiElement)context) || CssUtil.isInsideFontFace((PsiElement)context) || CssUtil.isInsidePageRuleset((PsiElement)context))) {
            String[] stringArray = ArrayUtil.toStringArray(WebComponentsUtil.getSelectors(context.getProject()));
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider", "getSimpleSelectors"));
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider", "getSimpleSelectors"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        if (WebComponentsIndex.getNames(selector.getProject()).contains(selector.getElementName())) {
            PsiElement[] psiElementArray = WebComponentCssElementDescriptorProvider.tryFindWebComponent(selector);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static PsiElement[] tryFindWebComponent(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/webcomponents/css/WebComponentCssElementDescriptorProvider", "tryFindWebComponent"));
        }
        String selectorName = selector.getElementName();
        THashSet keys = new THashSet();
        keys.add(selectorName);
        ArrayList<PsiElement> declarations = WebComponentsIndex.findDeclarations((Set<String>)keys, selector.getManager(), selector.getResolveScope());
        return (PsiElement[])ArrayUtil.toObjectArray(declarations, PsiElement.class);
    }
}

