/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.descriptor;

import com.intellij.codeInsight.completion.TagNameReferenceCompletionProvider;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcomponents.descriptor.SimpleTagWithNameDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementTagDescriptor
extends SimpleTagWithNameDescriptor {
    public ElementTagDescriptor(XmlTag xmlTag) {
        super(xmlTag);
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        ArrayList<XmlAttributeDescriptor> result = new ArrayList<XmlAttributeDescriptor>(Arrays.asList(super.getAttributesDescriptors(context)));
        result.add((XmlAttributeDescriptor)new AnyXmlAttributeDescriptor(this.getIdAttributeName(context)){

            public boolean isRequired() {
                return true;
            }
        });
        result.add((XmlAttributeDescriptor)new ExtendsAttributeDescriptor());
        result.add((XmlAttributeDescriptor)new AnyXmlAttributeDescriptor("constructor"));
        return (XmlAttributeDescriptor[])ContainerUtil.toArray(result, (Object[])XmlAttributeDescriptor.EMPTY);
    }

    @NotNull
    protected String getIdAttributeName(@Nullable XmlTag context) {
        if ("name" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/descriptor/ElementTagDescriptor", "getIdAttributeName"));
        }
        return "name";
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        return (XmlAttributeDescriptor)ContainerUtil.find((Object[])this.getAttributesDescriptors(context), descriptor -> attributeName.equalsIgnoreCase(descriptor.getName()));
    }

    private class ExtendsAttributeDescriptor
    extends AnyXmlAttributeDescriptor {
        public ExtendsAttributeDescriptor() {
            super("extends");
        }

        public String getDefaultValue() {
            return "";
        }

        public boolean isEnumerated() {
            return true;
        }

        public String[] getEnumeratedValues() {
            PsiReference reference = ElementTagDescriptor.this.myXmlTag.getReference();
            if (reference instanceof TagNameReference) {
                ArrayList result = new ArrayList();
                TagNameReferenceCompletionProvider.collectCompletionVariants((TagNameReference)((TagNameReference)reference), element -> result.add(element.getLookupString()));
                return (String[])ContainerUtil.toArray(result, (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }
}

