/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.webcomponents.util.WebComponentsUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebComponentsIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> WEB_COMPONENTS_INDEX = ID.create((String)"WebComponentsIndex");
    private static final int INDEX_VERSION = 5;
    private DataIndexer<String, Void, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = WEB_COMPONENTS_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/index/WebComponentsIndex", "getName"));
        }
        return iD;
    }

    public int getVersion() {
        return 5;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/index/WebComponentsIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/index/WebComponentsIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.HTML, StdFileTypes.XHTML}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcomponents/index/WebComponentsIndex$1", "acceptInput"));
                }
                return super.acceptInput(file) && !(file.getFileSystem() instanceof JarFileSystem);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/index/WebComponentsIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static Collection<String> getNames(Project project) {
        boolean dumb = DumbServiceImpl.getInstance((Project)project).isDumb();
        return dumb ? Collections.emptyList() : WebComponentsIndex.getAllKeys(project);
    }

    private static Collection<String> getAllKeys(Project project) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        Collection keys = FileBasedIndex.getInstance().getAllKeys(WEB_COMPONENTS_INDEX, project);
        return new THashSet((Collection)ContainerUtil.filter((Collection)keys, key -> !FileBasedIndex.getInstance().processValues(WEB_COMPONENTS_INDEX, key, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>(){

            public boolean process(VirtualFile file, Void value) {
                return false;
            }
        }, scope)));
    }

    @NotNull
    public static ArrayList<PsiElement> findDeclarations(Set<String> keys, PsiManager psiManager, GlobalSearchScope scope) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        FileBasedIndex.getInstance().getFilesWithKey(WEB_COMPONENTS_INDEX, keys, file -> {
            WebComponentsUtil.processElementTags(psiManager.findFile(file), (Processor<XmlAttribute>)((Processor)xmlAttribute -> {
                result.add((PsiElement)xmlAttribute);
                return true;
            }));
            return false;
        }, scope);
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/index/WebComponentsIndex", "findDeclarations"));
        }
        return arrayList;
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/webcomponents/index/WebComponentsIndex$MyDataIndexer", "map"));
            }
            THashMap result = new THashMap();
            PsiFile psiFile = inputData.getPsiFile();
            WebComponentsUtil.processElementTags(psiFile, (Processor<XmlAttribute>)((Processor)arg_0 -> MyDataIndexer.lambda$map$0((Map)result, arg_0)));
            THashMap tHashMap = result;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/index/WebComponentsIndex$MyDataIndexer", "map"));
            }
            return tHashMap;
        }

        private static /* synthetic */ boolean lambda$map$0(Map result, XmlAttribute xmlAttribute) {
            result.put(xmlAttribute.getValue(), null);
            return true;
        }
    }
}

