/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.util;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.webcomponents.index.WebComponentsIndex;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebComponentsUtil {
    public static final String ELEMENT = "element";
    public static final String POLYMER_ELEMENT = "polymer-element";
    public static final String DOM_MODULE = "dom-module";
    public static final String TEMPLATE = "template";
    public static final String NAME = "name";
    public static final String EXTENDS = "extends";
    public static final String CONSTRUCTOR = "constructor";
    public static final String DECORATOR = "decorator";
    public static final String SHADOW = "shadow";
    public static final String CONTENT = "content";
    public static final String ID = "id";
    public static final String IF = "if";
    public static final String REPEAT = "repeat";
    public static final String BIND = "bind";
    public static final String REF = "ref";
    public static final String IS = "is";
    public static final String SELECT = "select";
    public static final String RESET_STYLE_INHERITANCE = "resetstyleinheritance";
    public static final String LAYOUT_HTML = "layout.html";
    public static final String POLYMER_HTML = "polymer.html";
    private static final Set<String> myTagNames = ContainerUtil.immutableSet((Object[])new String[]{"element", "polymer-element", "template", "decorator", "shadow", "content"});
    public static final Key<ParameterizedCachedValue<Boolean, PsiElement>> IS_POLYMER_PROJECT_KEY = Key.create((String)"is.polymer.project");
    public static final ParameterizedCachedValueProvider<Boolean, PsiElement> IS_POLYMER_PROJECT_PROVIDER = new ParameterizedCachedValueProvider<Boolean, PsiElement>(){

        @Nullable
        public CachedValueProvider.Result<Boolean> compute(PsiElement param) {
            GlobalSearchScope scope;
            Project project = param.getProject();
            return CachedValueProvider.Result.create((Object)(FilenameIndex.getFilesByName((Project)project, (String)WebComponentsUtil.POLYMER_HTML, (GlobalSearchScope)(scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)param))).length > 0 || FilenameIndex.getFilesByName((Project)project, (String)WebComponentsUtil.LAYOUT_HTML, (GlobalSearchScope)scope).length > 0 ? 1 : 0), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        }
    };

    public static boolean processElementTags(PsiFile psiFile, final Processor<XmlAttribute> processor) {
        final Ref result = Ref.create((Object)true);
        PsiFile xmlFile = psiFile.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE);
        if (xmlFile != null) {
            xmlFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    boolean needToGoDeeper = true;
                    String tagName = tag.getName();
                    boolean polymer10 = WebComponentsUtil.DOM_MODULE.equalsIgnoreCase(tagName);
                    if (WebComponentsUtil.ELEMENT.equalsIgnoreCase(tagName) || WebComponentsUtil.POLYMER_ELEMENT.equalsIgnoreCase(tagName) || polymer10) {
                        XmlAttribute xmlAttribute = polymer10 ? tag.getAttribute(WebComponentsUtil.ID) : tag.getAttribute(WebComponentsUtil.NAME);
                        needToGoDeeper = xmlAttribute == null || xmlAttribute.getValue() == null || processor.process((Object)xmlAttribute);
                    }
                    result.set((Object)needToGoDeeper);
                    if (needToGoDeeper) {
                        super.visitXmlTag(tag);
                    }
                }
            });
        }
        return (Boolean)result.get();
    }

    public static boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/webcomponents/util/WebComponentsUtil", "isPossibleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/webcomponents/util/WebComponentsUtil", "isPossibleSelector"));
        }
        if (myTagNames.contains(selector)) {
            return true;
        }
        final Ref result = Ref.create((Object)false);
        FileBasedIndex.getInstance().processValues(WebComponentsIndex.WEB_COMPONENTS_INDEX, (Object)selector, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>(){

            public boolean process(VirtualFile file, Void value) {
                result.set((Object)true);
                return false;
            }
        }, GlobalSearchScope.allScope((Project)context.getProject()));
        return (Boolean)result.get();
    }

    @NotNull
    public static Set<String> getSelectors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcomponents/util/WebComponentsUtil", "getSelectors"));
        }
        Collection<String> namesFromIndex = WebComponentsIndex.getNames(project);
        Set<String> set = namesFromIndex.isEmpty() ? myTagNames : WebComponentsUtil.concatinateToImmutable(myTagNames, namesFromIndex);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcomponents/util/WebComponentsUtil", "getSelectors"));
        }
        return set;
    }

    private static Set<String> concatinateToImmutable(@NotNull Collection<String> collection1, @NotNull Collection<String> collection2) {
        if (collection1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection1", "com/intellij/webcomponents/util/WebComponentsUtil", "concatinateToImmutable"));
        }
        if (collection2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection2", "com/intellij/webcomponents/util/WebComponentsUtil", "concatinateToImmutable"));
        }
        THashSet result = new THashSet(collection1.size() + collection2.size());
        result.addAll(collection1);
        result.addAll(collection2);
        return Collections.unmodifiableSet(result);
    }

    public static boolean hasPolymerJs(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT, "com/intellij/webcomponents/util/WebComponentsUtil", "hasPolymerJs"));
        }
        Project project = element.getProject();
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        return (Boolean)manager.getParameterizedCachedValue((UserDataHolder)project, IS_POLYMER_PROJECT_KEY, IS_POLYMER_PROJECT_PROVIDER, false, (Object)element);
    }
}

