/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.xml;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.webcomponents.index.WebComponentsIndex;
import com.intellij.webcomponents.util.WebComponentsUtil;
import com.intellij.xml.XmlTagNameProvider;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebComponentsTagNameProvider
implements XmlTagNameProvider {
    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        XmlTag parentTag;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/webcomponents/xml/WebComponentsTagNameProvider", "addTagNameVariants"));
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        if (!HtmlUtil.isHtml5Context((XmlElement)tag)) {
            return;
        }
        elements.add(WebComponentsTagNameProvider.createLookup("element"));
        if (WebComponentsUtil.hasPolymerJs((PsiElement)tag)) {
            elements.add(WebComponentsTagNameProvider.createLookup("dom-module"));
        }
        if ((parentTag = tag.getParentTag()) != null && "template".equalsIgnoreCase(parentTag.getName())) {
            elements.add(WebComponentsTagNameProvider.createLookup("shadow"));
        }
        for (String componentName : WebComponentsIndex.getNames(tag.getProject())) {
            elements.add(WebComponentsTagNameProvider.createLookup(componentName));
        }
    }

    private static LookupElement createLookup(String componentName) {
        LookupElementBuilder lookupElement = LookupElementBuilder.create((String)componentName);
        return lookupElement.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
    }
}

