/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.HamlIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.HamlBundle;
import org.jetbrains.plugins.haml.highlighter.HAMLEditorHighlighter;

public class HAMLFileType
extends LanguageFileType {
    public static final HAMLFileType HAML = new HAMLFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "haml";
    @NonNls
    private static final String NAME = "Haml";
    @NonNls
    private static final String DESCRIPTION = HamlBundle.message("filetype.description.haml");

    protected HAMLFileType() {
        super((Language)HAMLLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "org/jetbrains/plugins/haml/HAMLFileType$1", "getEditorHighlighter"));
                }
                if (colors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "org/jetbrains/plugins/haml/HAMLFileType$1", "getEditorHighlighter"));
                }
                return new HAMLEditorHighlighter(colors, project, virtualFile);
            }
        });
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/HAMLFileType", "getName"));
        }
        return NAME;
    }

    @NotNull
    public String getDescription() {
        String string = DESCRIPTION;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/HAMLFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/HAMLFileType", "getDefaultExtension"));
        }
        return DEFAULT_EXTENSION;
    }

    @Nullable
    public Icon getIcon() {
        return HamlIcons.Haml;
    }
}

