/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlInjectedLanguageBlockBuilder;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.psi.HAMLElementTypes;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;

public class HamlBlock
implements ASTBlock {
    private static final TokenSet BLOCKS_TO_INDENT = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{HAMLElementTypes.HAML_TAG}), HAMLTokenTypes.COMMENTS});
    private static final TokenSet BLOCKS_TO_BE_RELATIVE_TO_PARENT = TokenSet.create((IElementType[])new IElementType[0]);
    private static final TokenSet BLOCKS_TO_INDENT_CHILDREN = TokenSet.create((IElementType[])new IElementType[]{HAMLElementTypes.HAML_TAG});
    private final ASTNode myNode;
    private final Indent myIndent;
    private final TextRange myTextRange;
    private final boolean myLeaf;
    private List<Block> myChildren = null;
    private final XmlInjectedLanguageBlockBuilder myInjectedBlockBuilder;
    private final XmlFormattingPolicy myXmlPolicy;

    public HamlBlock(ASTNode node, XmlFormattingPolicy policy) {
        this(node, Indent.getAbsoluteNoneIndent(), policy);
    }

    public HamlBlock(ASTNode node, Indent indent, XmlFormattingPolicy policy) {
        this(node, indent, node.getTextRange(), policy);
    }

    public HamlBlock(ASTNode node, Indent indent, TextRange textRange, XmlFormattingPolicy policy) {
        this(node, indent, textRange, false, policy);
    }

    public HamlBlock(ASTNode node, Indent indent, TextRange textRange, boolean leaf, XmlFormattingPolicy policy) {
        this.myNode = node;
        this.myIndent = indent;
        this.myTextRange = textRange;
        this.myLeaf = leaf;
        this.myXmlPolicy = policy;
        this.myInjectedBlockBuilder = new XmlInjectedLanguageBlockBuilder(policy);
    }

    public ASTNode getNode() {
        return this.myNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/formatter/HamlBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.myLeaf) {
            List<Block> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/formatter/HamlBlock", "getSubBlocks"));
            }
            return list;
        }
        if (this.myChildren == null) {
            this.myChildren = this.buildChildren();
        }
        List<Block> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/formatter/HamlBlock", "getSubBlocks"));
        }
        return list;
    }

    private List<Block> buildChildren() {
        ASTNode[] children = this.myNode.getChildren(null);
        if (children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode child : children) {
            if (child.getText().length() == 0 || child.getElementType() == HAMLTokenTypes.WHITESPACE || child.getElementType() == TokenType.WHITE_SPACE || child.getElementType() == HAMLTokenTypes.INDENT || child.getElementType() == HAMLTokenTypes.EOL) continue;
            if (!HamlBlock.isHamlElement(child)) {
                this.myInjectedBlockBuilder.addInjectedLanguageBlockWrapper(result, child, Indent.getNormalIndent(), 0, null);
                continue;
            }
            boolean indented = false;
            if (child.getStartOffset() > 0) {
                int index = child.getStartOffset() - 1;
                PsiFile file = child.getPsi().getContainingFile();
                PsiElement elementAtIndex = file.findElementAt(index);
                if (elementAtIndex != null) {
                    ASTNode probableWhitespace = elementAtIndex.getNode();
                    boolean bl = indented = probableWhitespace.getElementType() == HAMLTokenTypes.INDENT;
                }
            }
            Indent indent = child.getTextRange().getStartOffset() > 0 && indented && BLOCKS_TO_INDENT.contains(child.getElementType()) ? Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)true) : (BLOCKS_TO_BE_RELATIVE_TO_PARENT.contains(child.getElementType()) ? Indent.getIndent((Indent.Type)Indent.Type.NONE, (boolean)true, (boolean)false) : Indent.getNoneIndent());
            result.add((Block)new HamlBlock(child, indent, this.myXmlPolicy));
        }
        return result;
    }

    private static boolean isHamlElement(ASTNode child) {
        return child.getPsi().getLanguage() == XMLLanguage.INSTANCE || child.getPsi().getLanguage() == HAMLLanguage.INSTANCE;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public Alignment getAlignment() {
        return null;
    }

    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/haml/formatter/HamlBlock", "getSpacing"));
        }
        if (child1 == null) {
            return null;
        }
        if (!(child2 instanceof ASTBlock)) {
            return null;
        }
        IElementType elementType2 = ((ASTBlock)child2).getNode().getElementType();
        if (HAMLTokenTypes.COMMENTS.contains(elementType2)) {
            return Spacing.getReadOnlySpacing();
        }
        return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)2);
    }

    @Nullable
    private ASTNode getNodeBefore(int childIndex) {
        if (childIndex == 0) {
            return null;
        }
        int prevIndex = childIndex - 1;
        ASTBlock insertAfterBlock = (ASTBlock)this.getSubBlocks().get(prevIndex);
        return insertAfterBlock.getNode();
    }

    @Nullable
    private static ASTNode findLastLeafOfPreviousElement(@NotNull ASTNode afterNode) {
        ASTNode result;
        if (afterNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterNode", "org/jetbrains/plugins/haml/formatter/HamlBlock", "findLastLeafOfPreviousElement"));
        }
        for (result = TreeUtil.findLastLeaf((ASTNode)afterNode); result != null && (result.getElementType() == TokenType.WHITE_SPACE || result.getElementType() == HAMLTokenTypes.INDENT); result = result.getTreePrev()) {
        }
        return result;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Language lang;
        ASTNode node;
        ASTNode afterNode = this.getNodeBefore(newChildIndex);
        if (afterNode != null && (node = HamlBlock.findLastLeafOfPreviousElement(afterNode)) != null && (lang = node.getPsi().getLanguage()) != HAMLLanguage.INSTANCE && lang != XMLLanguage.INSTANCE) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/formatter/HamlBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        Indent childIndent = BLOCKS_TO_INDENT_CHILDREN.contains(this.getNode().getElementType()) ? Indent.getNormalIndent() : Indent.getNoneIndent();
        ChildAttributes childAttributes = new ChildAttributes(childIndent, null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/formatter/HamlBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return this.getNode().getElementType() == HAMLElementTypes.HAML_TAG;
    }

    public boolean isLeaf() {
        return this.myLeaf;
    }
}

