/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;

public class _HAMLLexer
implements FlexLexer,
HAMLTokenTypes {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int IN_TAG_STATE = 2;
    public static final int IN_CLASS_STATE = 4;
    public static final int IN_ID_STATE = 6;
    public static final int AFTER_TAG_STATE = 8;
    public static final int AFTER_TAG_ARGS_STATE = 10;
    public static final int TAGS_ARG_STATE = 12;
    public static final int STRING_STATE = 14;
    public static final int TEXT_STATE = 16;
    public static final int RUBY_CODE_STATE = 18;
    public static final int RUBY_LINE_CODE_STATE = 20;
    public static final int RUBY_STRING_STATE = 22;
    public static final int COMMENT_STATE = 24;
    public static final int CONDITIONAL_COMMENT_STATE = 26;
    public static final int BLOCK_WITHOUT_INTERPOLATION_STATE = 28;
    public static final int BLOCK_WITH_INTERPOLATION_STATE = 30;
    public static final int IN_IMPLICIT_TAG_STATE = 32;
    public static final int IN_EXPLICIT_TAG_STATE = 34;
    public static final int AFTER_TAG_STATE_WITHOUT_RUBY_INJECTION = 36;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18};
    static final char[] ZZ_CMAP_Z = _HAMLLexer.zzUnpackCMap("\u0001\u0000\u0001@\u0001\u0080\u010d@");
    static final char[] ZZ_CMAP_Y = _HAMLLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001\u0001\u0002}\u0003\u0001\u0004?\u0003");
    static final char[] ZZ_CMAP_A = _HAMLLexer.zzUnpackCMap("\t\u0000\u0001\u0001\u0001\u0002\u0002\u0006\u0001\u0005\u0012\u0000\u0001 \u0001\u000f\u0001\t\u0001\b\u0001\u0000\u0001\u0010\u0001\u001b\u0001\u000b\u0001\u0018\u0001\u001f\u0002\u0000\u0001!\u0001\u0007\u0001\u0017\u0001\u0003\n\r\u0001\u000e\u0001\u0000\u0001\u0012\u0001\u001c\u0001\u0011\u0001\u0000\u0001\u001a\u001a\f\u0001\u0004\u0001\n\u0002\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0015\u000f\f\u0001\u0013\u0002\f\u0001\u0014\u0003\f\u0001\u0016\u0001\f\u0001\u0019\u0001\u001e\u0001\"\u0001\u001d\u0006\u0000\u0001\u0006\u00a2\u0000\u0002\u0006\u0016\u0000");
    private static final int[] ZZ_ACTION = _HAMLLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u000b\u0000\u0001\u0001\u0001\u0002\u0006\u0000\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0007\u0003\u0002\b\u0001\u0003\u0001\t\u0001\u0000\u0001\n\u0001\u000b\u0001\f\u0001\r\u0002\u0003\u0002\u000e\u0001\u0003\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0010\u0001\u0017\u0001\u0018\u0002\u0019\u0001\u001a\u0001\u001b\u0003\u001c\u0002\u001d\u0001\u001e\u0001\u001f\u0001\u001e\u0001\u0001\u0001\u0002\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001#\u0001$\u0001&\u0001\u0000\u0001\u0004\u0001\u0007\u0001'\u0001(\u0001)\u0002*\u0001\u0000\u0001+\u0001(\u0001,\u0001\u001c\u0002-\u0001.\u0001\r\u0001\u0000\u0003/\u0002\u0000\u00010\u0001\u0000\u00011\u0001\u0000\u00012\u00013\u00014\u00015\u0002\u001e\u0001\u0000\u0001 \u00016\u00017\u00018\u00019\u0001:\u0001;\u0001\u0000\u0001*\u0001<\u0001+\u0001\u0000\u0001+\u0002\u0000\u0001=\u0003\u0000\u0001\u001e\u0001>\u0001\u001e\u0001?\u0001@\u0002;\u0001*\u0001=\u0002\u0000\u0001A\u0001@\u0001B";
    private static final int[] ZZ_ROWMAP = _HAMLLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000#\u0000F\u0000i\u0000\u008c\u0000\u00af\u0000\u00d2\u0000\u00f5\u0000\u0118\u0000\u013b\u0000\u015e\u0000\u0181\u0000\u01a4\u0000\u01c7\u0000\u01ea\u0000\u020d\u0000\u0230\u0000\u0253\u0000\u0276\u0000\u01c7\u0000\u0299\u0000\u01c7\u0000\u02bc\u0000\u02df\u0000\u0302\u0000\u0325\u0000\u0348\u0000\u036b\u0000\u038e\u0000\u03b1\u0000\u03d4\u0000\u03f7\u0000\u041a\u0000\u043d\u0000\u0460\u0000\u0483\u0000\u04a6\u0000\u04c9\u0000\u04ec\u0000\u050f\u0000\u0532\u0000\u0555\u0000\u01c7\u0000\u0578\u0000\u059b\u0000\u01c7\u0000\u01c7\u0000\u05be\u0000\u05e1\u0000\u0604\u0000\u0627\u0000\u064a\u0000\u01c7\u0000\u066d\u0000\u0690\u0000\u01c7\u0000\u01c7\u0000\u06b3\u0000\u01c7\u0000\u01c7\u0000\u01c7\u0000\u06d6\u0000\u043d\u0000\u01c7\u0000\u043d\u0000\u06f9\u0000\u01c7\u0000\u071c\u0000\u073f\u0000\u0762\u0000\u0785\u0000\u07a8\u0000\u07cb\u0000\u07ee\u0000\u0811\u0000\u0834\u0000\u0857\u0000\u01c7\u0000\u01c7\u0000\u087a\u0000\u089d\u0000\u08c0\u0000\u01c7\u0000\u08e3\u0000\u01c7\u0000\u0906\u0000\u0929\u0000\u094c\u0000\u096f\u0000\u0992\u0000\u09b5\u0000\u09d8\u0000\u09fb\u0000\u01c7\u0000\u01c7\u0000\u01c7\u0000\u0532\u0000\u01c7\u0000\u0a1e\u0000\u0a41\u0000\u0a64\u0000\u0a87\u0000\u0aaa\u0000\u0acd\u0000\u0af0\u0000\u0b13\u0000\u0b36\u0000\u0b59\u0000\u01c7\u0000\u01c7\u0000\u0b7c\u0000\u0b9f\u0000\u0bc2\u0000\u0be5\u0000\u01c7\u0000\u0c08\u0000\u01c7\u0000\u0c2b\u0000\u01c7\u0000\u0c4e\u0000\u0c71\u0000\u0c94\u0000\u0cb7\u0000\u01c7\u0000\u038e\u0000\u0cda\u0000\u03b1\u0000\u09d8\u0000\u0cfd\u0000\u0d20\u0000\u0d43\u0000\u0d66\u0000\u0d89\u0000\u01c7\u0000\u0dac\u0000\u01c7\u0000\u0dcf\u0000\u01c7\u0000\u0df2\u0000\u0e15\u0000\u01c7\u0000\u0e38\u0000\u0e5b\u0000\u01c7\u0000\u01c7\u0000\u0906";
    private static final int[] ZZ_TRANS = _HAMLLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0003\u0014\u0001\u0018\u0001\u0019\u0001\u0014\u0001\u001a\u0003\u0014\u0001\u001b\u0001\u001c\u0001\u001d\u0006\u0014\u0001\u001e\u0003\u0014\u0001\u001f\u0001 \u0001!\u0001\"\u0001\u0014\u0001\u0015\u0002\u0014\f\u0000\u0001#\u0006\u0000\u0004#\u0013\u0000\u0001$\u0004\u0000\u0001%\u0006\u0000\u0004%\u0018\u0000\u0001&\u0006\u0000\u0004&\f\u0000\u0001\u0014\u0001'\u0001\u0016\u0001(\u0001)\u0003\u0014\u0001*\u0001\u0014\u0001+\u0003\u0014\u0001\u001b\u0001\u001f\u0001\u001d\u0001,\u0001+\u0004\u0014\u0001-\u0001.\u0001)\u0001\u0014\u0001\u001f\u0001 \u0001!\u0001\"\u0001\u0014\u0001'\u0003\u0014\u0001\u0015\u0001\u0016\u0001(\u000b\u0014\u0001\u001f\u000b\u0014\u0001\u001f\u0001 \u0001!\u0001\"\u0001\u0014\u0001\u0015\u0002\u0014\u0001/\u00020\u0002/\u0002\u0000\u0002/\u00011\u0001/\u00012\u00013\u00014\u0005/\u00043\u0001/\u00015\u0001/\u00016\u0001/\u00017\u0002/\u00018\u00010\u0002/\u00029\u0001/\u00029\u0002\u0000\u00019\u0001:\u0001;\u00019\u0001<\u00179\u0002=\u0001\u0016\u0005=\u0001>\u0015=\u0001?\u0004=\u0002@\u0001\u0016\u001b@\u0001A\u0004@\u0002B\u0001C\u001bB\u0001D\u0004B\u0002E\u0001\u0016 E\u0002F\u0001G F#\u0000\u0001H\u0001I\u0001J\u001dH\u0001I\u0002H\u0001K\u0001L\u0001M\u0005K\u0001N\u0010K\u0001N\u0006K\u0001L\u0001K\u0001N\u0002O\u0001\u0000\u0002O\u0002\u0000\u001cO\u0010\u0000\u0001P\u0012\u0000\u0001\u0014\u0001Q\u0001\u0016\u0001(\u0004\u0014\u0001*\u0001\u0014\u0001+\u0003\u0014\u0001\u001b\u0001\u001f\u0001\u001d\u0001,\u0001+\u0004\u0014\u0001-\u0001.\u0002\u0014\u0001\u001f\u0001 \u0001!\u0001\"\u0001\u0014\u0001Q\u0002\u0014\u0001\u0000\u0001\u0015\u001e\u0000\u0001\u0015\u0002\u0000\u0002\u0017\u0001\u0000\u0002\u0017\u0002\u0000\u001c\u0017\u0001\u0000\u0001R\u0006\u0000\u0001S\u0017\u0000\u0001R\u000e\u0000\u0001T\u0006\u0000\u0004T\f\u0000\u0002U\u0001\u0000\u0002U\u0002\u0000\u001cU\f\u0000\u0001V\u0006\u0000\u0001W\u0003V\u001b\u0000\u0001X\f\u0000\u0001!\u0012\u0000\u0001Y\u0006\u0000\u0004Y\u0018\u0000\u0001Z\u0006\u0000\u0004Z(\u0000\u0001!\u0007\u0000\u0001!\u001a\u0000\u0001[\u0003\u0000\u0001!\u0003\u0000\u0001!\u001e\u0000\u0001!\u0004\u0000\u0001\\\u0002\u0000\u0001]\u0001^#\u0000\u0001#\u0004\u0000\u0002#\u0001\u0002\u0004\u0000\u0004#\u0018\u0000\u0001%\u0006\u0000\u0004%\u0013\u0000\u0001%\u0004\u0000\u0002%\u0005\u0000\u0004%\u0013\u0000\u0001&\u0004\u0000\u0002&\u0005\u0000\u0004&\r\u0000\u0001'\u0016\u0000\u0001_\u0007\u0000\u0001'\u0003\u0000\u0001(\u0001`\u001d\u0000\u0001(\u0003\u0000\u0001a\u0002\u0000\u0001b\u0004\u0000\u0001b\u0001\u0000\u0001b\u0001c\u0001d\u0001e\u0004\u0000\u0004c\u0001\u0000\u0002b\u0001f\u0005\u0000\u0001a\u000e\u0000\u0001g\u0006\u0000\u0004g\u001e\u0000\u0001+\u0017\u0000\u0001h\u0004\u0000\u0001i\u0006\u0000\u0004i\r\u0000\u00020\u001d\u0000\u00010\u0002\u0000\u00021\u0001\u0000 1\u00022\u0001\u0000 2\u0007\u0000\u00013\u0004\u0000\u00023\u0001j\u0004\u0000\u00043\u0019\u0000\u00014!\u0000\u0001k\u0006\u0000\u0004k\u0018\u0000\u0001l\u0006\u0000\u0004l%\u0000\u0001m\"\u0000\u0001n\t\u0000\u0002B\u0001\u0000\u001dB\u0001o\u0001p\u0003B\u0001q\u001dB\u0001o\u0001p\u0001B\u0002E\u0001\u0000 E\u0002F\u0001\u0000 F\u0001\u0000\u0001r\u0001s\u001d\u0000\u0001r\u0002\u0000\u0002H\u0001\u0000\u0002H\u0002\u0000\u001cH\u0001\u0000\u0001I\u001e\u0000\u0001I\u0003\u0000\u0001t\u0001u\u001d\u0000\u0001t\u0002\u0000\u0002K\u0001\u0000\u0005K\u0001\u0000\u0010K\u0001\u0000\bK\u0001\u0000\u0001K\u0001L\u0001\u0000\u0005K\u0001\u0000\u0010K\u0001\u0000\u0006K\u0001L\u0001K\u0002\u0000\u0001v\u0001w\u001d\u0000\u0001v\u000e\u0000\u0001x\u0006\u0000\u0004x\r\u0000\u0001Q\u0016\u0000\u0001_\u0007\u0000\u0001Q\u0003\u0000\u0001R\u001e\u0000\u0001R\t\u0000\u0001T\u0004\u0000\u0002T\u0005\u0000\u0004T\u0013\u0000\u0001V\u0004\u0000\u0002V\u0001y\u0004\u0000\u0004V\u0013\u0000\u0001V\u0004\u0000\u0002V\u0001y\u0004\u0000\u0001V\u0001z\u0002V\u001b\u0000\u0001{\u001a\u0000\u0001Y\u0002\u0000\u0001|\u0001\u0000\u0002Y\u0001}\u0002\u0000\u0001~\u0001|\u0004Y\u0013\u0000\u0001Z\u0004\u0000\u0002Z\u0005\u0000\u0004Z\u0001\u007f\f\u0000\u0001[\u001e\u0000\u0001[\u0002\u0000\u0002\u0080\u0001\u0000\u001b\u0080\u0001\u0081\u0004\u0080\u0002\u0000\u0001^,\u0000\u0002c\u0005\u0000\u0004c\u0019\u0000\u0001d\u001e\u0000\u0001\u0082\u0001\u0000\u0001\u0083\u0001c\u0006\u0000\u0004c\u0018\u0000\u0001c\u0006\u0000\u0004c\u0003\u0000\u0001\u0084\u000f\u0000\u0001g\u0004\u0000\u0002g\u0005\u0000\u0004g\u0018\u0000\u0001i\u0006\u0000\u0004i\u0013\u0000\u0001i\u0004\u0000\u0002i\u0005\u0000\u0004i\u0018\u0000\u00013\u0006\u0000\u00043\u0013\u0000\u0001k\u0004\u0000\u0002k\u0005\u0000\u0004k\u0013\u0000\u0001l\u0004\u0000\u0002l\u0005\u0000\u0004l\f\u0000\u0002B\u0001\u0000\u001bB\u0001\u0085\u0001B\u0001o\u0001p\u0002B\u0001p\u0001\u0086\u001dB\u0001\u0087\u0001p\u0001B\u0002q\u0001\u0088\u001bq\u0001\u0089\u0004q\u0001\u0000\u0001r\u001e\u0000\u0001r\u0003\u0000\u0001t\u001e\u0000\u0001t\u0003\u0000\u0001v\u001e\u0000\u0001v\t\u0000\u0001x\u0002\u0000\u0001\u008a\u0001\u0000\u0002x\u0001P\u0002\u0000\u0001\u008b\u0001\u008a\u0004x\u0018\u0000\u0001V\u0006\u0000\u0004V\u0013\u0000\u0001V\u0004\u0000\u0002V\u0001y\u0004\u0000\u0002V\u0001\u008c\u0001V\f\u0000\u0002{\u0001\u0000 {\u0012\u0000\u0001|\u0010\u0000\u0002\u0080\u0001\u008d\u001b\u0080\u0001\u0081\u0004\u0080\t\u0082\u0001b\u0001\u008e\u0018\u0082\n\u0083\u0001\u008f\u0001b\u0017\u0083\f\u0000\u0001c\u0006\u0000\u0004c\f\u0000\u0002B\u0001\u0090\u001dB\u0001o\u0001p\u0002B\u0001p\u0001\u0086\u001bB\u0001\u0085\u0001B\u0001\u0087\u0001p\u0001B\u0002q\u0001\u0091\u001bq\u0001\u0089\u0004q\u0012\u0000\u0001\u008a\u0017\u0000\u0001V\u0004\u0000\u0002V\u0001y\u0004\u0000\u0003V\u0001\u0092\f\u0000\u0002\u0082\u0001\u0000\u0002\u0082\u0002\u0000\u001c\u0082\u0002\u0083\u0001\u0000\u0002\u0083\u0002\u0000\u001c\u0083";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _HAMLLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u000b\u0000\u0002\u0001\u0001\b\u0005\u0000\u0001\t\u0001\u0001\u0001\t\r\u0001\u0001\u0000\u0006\u0001\u0001\t\u0002\u0001\u0002\t\u0005\u0001\u0001\t\u0002\u0001\u0002\t\u0001\u0001\u0003\t\u0002\u0001\u0001\t\u0002\u0001\u0001\t\n\u0001\u0002\t\u0001\u0000\u0002\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0001\u0000\u0005\u0001\u0003\t\u0001\u0000\u0001\t\u0002\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0002\t\u0002\u0001\u0001\u0000\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\u0000\u0002\u0001\u0001\t\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0002\u0000\u0002\t\u0001\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int filterContentIndent = 0;
    private int commentIndent = 0;
    private BlockState myState;
    private int braceBalance;
    private char openBrace;
    private char closeBrace;
    private boolean includeDelimiter;
    private int nextState;
    private boolean lineContinuationSeen = false;
    private boolean injectionParam = false;
    private boolean interpolatedString = false;
    private IElementType myCommentType = null;
    private int myCommentIndent = 0;
    private boolean myConditionalComment = false;

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 12] | ch >> 6 & 0x3F] << 6 | ch & 0x3F];
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[146];
        int offset = 0;
        offset = _HAMLLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[146];
        int offset = 0;
        offset = _HAMLLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[3710];
        int offset = 0;
        offset = _HAMLLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[146];
        int offset = 0;
        offset = _HAMLLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private int getIndent() {
        int commentIndent = 0;
        int loc = this.getTokenStart() - 1;
        while (0 <= loc && this.zzBuffer.charAt(loc) != '\n') {
            --loc;
            ++commentIndent;
        }
        return commentIndent;
    }

    private void yyBegin(int newState) {
        this.yybegin(newState);
    }

    private char previousChar() {
        return this.charAt(-1);
    }

    private char charAt(int offset) {
        int loc = this.getTokenStart() + offset;
        return 0 <= loc && loc < this.zzBuffer.length() ? this.zzBuffer.charAt(loc) : (char)'\uffff';
    }

    private void readParens() {
        char c;
        int length;
        this.braceBalance = 1;
        int n = length = this.includeDelimiter ? 1 : 0;
        while (this.braceBalance != 0 && (c = this.charAt(length)) != '\uffff') {
            if (c == this.openBrace) {
                ++this.braceBalance;
            }
            if (c == this.closeBrace) {
                --this.braceBalance;
            }
            ++length;
        }
        this.zzMarkedPos += length - 1;
        if (!this.includeDelimiter) {
            --this.zzMarkedPos;
        }
    }

    private boolean doesPipeBelongToRuby(String text) {
        int i;
        text = text.trim();
        for (i = text.length() - 2; i >= 0 && text.charAt(i) != '|'; --i) {
        }
        if (i > 0) {
            --i;
            while (i >= 0 && StringUtil.isWhiteSpace((char)text.charAt(i))) {
                --i;
            }
            return i >= 2 && text.substring(i - 1, i + 1).equals("do");
        }
        return false;
    }

    public _HAMLLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i = 0; i < length; i += 2) {
            size += packed.charAt(i);
        }
        char[] map = new char[size];
        int i = 0;
        int j = 0;
        while (i < packed.length()) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block134: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _HAMLLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return RUBY_STRING;
                }
                case 67: {
                    continue block134;
                }
                case 2: {
                    return this.myCommentType;
                }
                case 68: {
                    continue block134;
                }
                case 3: {
                    this.yypushback(1);
                    this.yyBegin(16);
                }
                case 69: {
                    continue block134;
                }
                case 4: {
                    char prev = this.previousChar();
                    return prev == '\n' || prev == '\uffff' ? INDENT : WHITESPACE;
                }
                case 70: {
                    continue block134;
                }
                case 5: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 71: {
                    continue block134;
                }
                case 6: {
                    this.myConditionalComment = this.yytext().toString().startsWith("/[");
                    this.myCommentType = HTML_COMMENT;
                    this.myCommentIndent = this.getIndent();
                    this.yybegin(24);
                    return this.myCommentType;
                }
                case 72: {
                    continue block134;
                }
                case 7: {
                    this.yyBegin(20);
                    this.lineContinuationSeen = false;
                    return RUBY_CODE_MARKER;
                }
                case 73: {
                    continue block134;
                }
                case 8: {
                    this.yyBegin(20);
                    this.lineContinuationSeen = false;
                    return RUBY_CODE_MARKER;
                }
                case 74: {
                    continue block134;
                }
                case 9: {
                    this.yyBegin(8);
                    return TAG_NAME;
                }
                case 75: {
                    continue block134;
                }
                case 10: {
                    this.yyBegin(8);
                    return CLASS;
                }
                case 76: {
                    continue block134;
                }
                case 11: {
                    this.yyBegin(8);
                    return ID;
                }
                case 77: {
                    continue block134;
                }
                case 12: {
                    this.yyBegin(36);
                    char prev = this.previousChar();
                    return prev == '\n' || prev == '\uffff' ? INDENT : WHITESPACE;
                }
                case 78: {
                    continue block134;
                }
                case 13: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    this.yyBegin(0);
                    return CLOSE_TAG;
                }
                case 79: {
                    continue block134;
                }
                case 14: {
                    return SPACE_EATER;
                }
                case 80: {
                    continue block134;
                }
                case 15: {
                    this.yypushback(1);
                    this.openBrace = (char)40;
                    this.closeBrace = (char)41;
                    this.includeDelimiter = true;
                    this.yyBegin(12);
                }
                case 81: {
                    continue block134;
                }
                case 16: {
                    this.injectionParam = false;
                    this.yypushback(1);
                    this.yyBegin(0);
                }
                case 82: {
                    continue block134;
                }
                case 17: {
                    this.injectionParam = false;
                    return WHITESPACE;
                }
                case 83: {
                    continue block134;
                }
                case 18: {
                    this.interpolatedString = true;
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(14);
                    return DOUBLE_QUOTE;
                }
                case 84: {
                    continue block134;
                }
                case 19: {
                    this.interpolatedString = false;
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(14);
                    return SINGLE_QUOTE;
                }
                case 85: {
                    continue block134;
                }
                case 20: {
                    return this.injectionParam ? INJECTION_CODE : PARAM;
                }
                case 86: {
                    continue block134;
                }
                case 21: {
                    return PARAM;
                }
                case 87: {
                    continue block134;
                }
                case 22: {
                    return OP_BRACE;
                }
                case 88: {
                    continue block134;
                }
                case 23: {
                    return EQUALS;
                }
                case 89: {
                    continue block134;
                }
                case 24: {
                    this.injectionParam = false;
                    this.yyBegin(8);
                    return CL_BRACE;
                }
                case 90: {
                    continue block134;
                }
                case 25: {
                    return this.interpolatedString ? INTERPOLATED_STRING : STRING;
                }
                case 91: {
                    continue block134;
                }
                case 26: {
                    if (this.interpolatedString && (this.charAt(-1) != '\\' || this.charAt(-2) == '\\')) {
                        this.yyBegin(12);
                    }
                    return this.interpolatedString ? DOUBLE_QUOTE : STRING;
                }
                case 92: {
                    continue block134;
                }
                case 27: {
                    if (!(this.interpolatedString || this.charAt(-1) == '\\' && this.charAt(-2) != '\\')) {
                        this.yyBegin(12);
                    }
                    return this.interpolatedString ? INTERPOLATED_STRING : SINGLE_QUOTE;
                }
                case 93: {
                    continue block134;
                }
                case 28: {
                    return TEXT;
                }
                case 94: {
                    continue block134;
                }
                case 29: {
                    this.readParens();
                    this.yyBegin(this.nextState);
                    return INJECTION_CODE;
                }
                case 95: {
                    continue block134;
                }
                case 30: {
                    if (this.lineContinuationSeen) {
                        if (this.charAt(this.yylength() - 1) == '|') {
                            if (this.yylength() > 1) {
                                this.yypushback(1);
                                return INJECTION_CODE;
                            }
                            return LINE_CONTINUATION;
                        }
                        this.yypushback(this.yylength());
                        this.yyBegin(0);
                    } else {
                        return INJECTION_CODE;
                    }
                }
                case 96: {
                    continue block134;
                }
                case 31: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 97: {
                    continue block134;
                }
                case 32: {
                    if (this.myConditionalComment) {
                        this.yybegin(0);
                        return EOL;
                    }
                    if (this.yylength() - 1 > this.myCommentIndent) {
                        return this.myCommentType;
                    }
                    this.yybegin(0);
                    this.yypushback(this.yylength());
                }
                case 98: {
                    continue block134;
                }
                case 33: {
                    return this.myState == BlockState.RUBY_STATE ? INJECTION_CODE : HAML_COMMENT;
                }
                case 99: {
                    continue block134;
                }
                case 34: {
                    if (this.previousChar() == '\n' && this.filterContentIndent >= this.yylength()) {
                        this.yyBegin(0);
                        return INDENT;
                    }
                    return this.myState == BlockState.RUBY_STATE ? INJECTION_CODE : HAML_COMMENT;
                }
                case 100: {
                    continue block134;
                }
                case 35: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 101: {
                    continue block134;
                }
                case 36: {
                    if (this.charAt(-1) == '{' && this.charAt(-2) == '#' && (this.charAt(-3) != '\\' || this.charAt(-4) == '\\')) {
                        this.openBrace = (char)123;
                        this.closeBrace = (char)125;
                        this.includeDelimiter = false;
                        this.nextState = 30;
                        this.yyBegin(18);
                        return INJECTION_CODE;
                    }
                    return FILTER_CONTENT;
                }
                case 102: {
                    continue block134;
                }
                case 37: {
                    if (this.previousChar() == '\n' && this.filterContentIndent >= this.yylength()) {
                        this.yyBegin(0);
                        return INDENT;
                    }
                    return FILTER_CONTENT;
                }
                case 103: {
                    continue block134;
                }
                case 38: {
                    this.yypushback(this.yylength());
                    this.yyBegin(8);
                    return PSEUDO_TAG_NAME;
                }
                case 104: {
                    continue block134;
                }
                case 39: {
                    this.myCommentType = HAML_COMMENT;
                    this.myCommentIndent = this.getIndent();
                    this.yybegin(24);
                    return this.myCommentType;
                }
                case 105: {
                    continue block134;
                }
                case 40: {
                    this.yypushback(this.yylength());
                    this.yyBegin(32);
                    return PSEUDO_TAG_START;
                }
                case 106: {
                    continue block134;
                }
                case 41: {
                    this.yyBegin(16);
                    return ESCAPE;
                }
                case 107: {
                    continue block134;
                }
                case 42: {
                    this.yyBegin(30);
                    this.myState = BlockState.FILTER_STATE;
                    this.filterContentIndent = this.getIndent();
                    return FILTER;
                }
                case 108: {
                    continue block134;
                }
                case 43: {
                    this.yypushback(this.yylength());
                    this.yyBegin(34);
                    return PSEUDO_TAG_START;
                }
                case 109: {
                    continue block134;
                }
                case 44: {
                    this.yyBegin(22);
                    return RUBY_STRING_MARKER;
                }
                case 110: {
                    continue block134;
                }
                case 45: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return TEXT;
                }
                case 111: {
                    continue block134;
                }
                case 46: {
                    this.yypushback(1);
                    this.yyBegin(16);
                    return WHITESPACE;
                }
                case 112: {
                    continue block134;
                }
                case 47: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    this.yypushback(1);
                    this.nextState = this.openBrace == '[' ? 36 : 8;
                    this.openBrace = this.charAt(0);
                    this.closeBrace = (char)(this.openBrace == '{' ? 125 : 93);
                    this.includeDelimiter = true;
                    this.yyBegin(18);
                    if (this.nextState == 36) {
                        return RUBY_CODE_MARKER;
                    }
                }
                case 113: {
                    continue block134;
                }
                case 48: {
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(6);
                    return ID_START;
                }
                case 114: {
                    continue block134;
                }
                case 49: {
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(4);
                    return CLASS_START;
                }
                case 115: {
                    continue block134;
                }
                case 50: {
                    return INJECTION_CODE;
                }
                case 116: {
                    continue block134;
                }
                case 51: {
                    this.yypushback(this.yylength() - 1);
                    this.injectionParam = true;
                    return EQUALS;
                }
                case 117: {
                    continue block134;
                }
                case 52: {
                    if (this.interpolatedString && (this.charAt(-1) != '\\' || this.charAt(-2) == '\\')) {
                        this.openBrace = (char)123;
                        this.closeBrace = (char)125;
                        this.includeDelimiter = false;
                        this.nextState = 14;
                        this.yyBegin(18);
                    }
                    return this.interpolatedString ? INTERPOLATED_STRING : STRING;
                }
                case 118: {
                    continue block134;
                }
                case 53: {
                    if (this.charAt(-1) != '\\' || this.charAt(-2) == '\\') {
                        this.openBrace = (char)123;
                        this.closeBrace = (char)125;
                        this.includeDelimiter = false;
                        this.nextState = 16;
                        this.yyBegin(18);
                    }
                    return TEXT;
                }
                case 119: {
                    continue block134;
                }
                case 54: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return this.myCommentType;
                }
                case 120: {
                    continue block134;
                }
                case 55: {
                    if (this.filterContentIndent < this.yylength() - 1) {
                        this.yypushback(this.yylength() - 1);
                        return this.myState == BlockState.RUBY_STATE ? INJECTION_CODE : HAML_COMMENT;
                    }
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(0);
                    return EOL;
                }
                case 121: {
                    continue block134;
                }
                case 56: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return this.myState == BlockState.RUBY_STATE ? INJECTION_CODE : HAML_COMMENT;
                }
                case 122: {
                    continue block134;
                }
                case 57: {
                    if (this.filterContentIndent < this.yylength() - 1) {
                        this.yypushback(this.yylength() - 1);
                        return FILTER_CONTENT;
                    }
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(0);
                    return EOL;
                }
                case 123: {
                    continue block134;
                }
                case 58: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return FILTER_CONTENT;
                }
                case 124: {
                    continue block134;
                }
                case 59: {
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(2);
                    return TAG_START;
                }
                case 125: {
                    continue block134;
                }
                case 60: {
                    return XHTML;
                }
                case 126: {
                    continue block134;
                }
                case 61: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 2);
                    this.yyBegin(0);
                    return LINE_CONTINUATION;
                }
                case 127: {
                    continue block134;
                }
                case 62: {
                    if (this.lineContinuationSeen) {
                        this.yypushback(this.yylength());
                        this.yyBegin(0);
                    } else {
                        return INJECTION_CODE;
                    }
                }
                case 128: {
                    continue block134;
                }
                case 63: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 2);
                    this.yyBegin(0);
                    return EOL;
                }
                case 129: {
                    continue block134;
                }
                case 64: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 2);
                    this.lineContinuationSeen = true;
                    return LINE_CONTINUATION;
                }
                case 130: {
                    continue block134;
                }
                case 65: {
                    if (this.doesPipeBelongToRuby(this.yytext().toString())) {
                        this.yypushback(1);
                    } else {
                        this.yypushback(2);
                    }
                    return INJECTION_CODE;
                }
                case 131: {
                    continue block134;
                }
                case 66: {
                    this.yyBegin(28);
                    this.myState = BlockState.RUBY_STATE;
                    this.filterContentIndent = this.getIndent();
                    return FILTER;
                }
                case 132: {
                    continue block134;
                }
            }
            this.zzScanError(1);
        }
    }

    static enum BlockState {
        FILTER_STATE,
        RUBY_STATE,
        COMMENT_STATE;

    }
}

