/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.HAMLLanguage;

public class HAMLLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        HAMLLanguage hAMLLanguage = HAMLLanguage.INSTANCE;
        if (hAMLLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/settings/HAMLLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return hAMLLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "org/jetbrains/plugins/haml/settings/HAMLLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return "#content\n  %h1\n    %h2\n      text text text\n      text text text\n    #my\n      .middle.center\n        text text text";
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings((Language)HAMLLanguage.INSTANCE);
        CommonCodeStyleSettings.IndentOptions indentOptions = defaultSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        return defaultSettings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }
}

