/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

public class YAMLUtil {
    @NotNull
    public static String getFullKey(YAMLKeyValue yamlKeyValue) {
        PsiElement parent;
        StringBuilder builder = new StringBuilder();
        YAMLKeyValue element = yamlKeyValue;
        while (element != null && (parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{YAMLKeyValue.class, YAMLDocument.class})) instanceof YAMLKeyValue) {
            if (builder.length() > 0) {
                builder.insert(0, '.');
            }
            builder.insert(0, element.getKeyText());
            element = (YAMLKeyValue)parent;
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLUtil", "getFullKey"));
        }
        return string;
    }

    @NotNull
    public static Collection<YAMLKeyValue> getTopLevelKeys(YAMLFile file) {
        YAMLValue topLevelValue = file.getDocuments().get(0).getTopLevelValue();
        if (topLevelValue instanceof YAMLMapping) {
            Collection<YAMLKeyValue> collection = ((YAMLMapping)topLevelValue).getKeyValues();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLUtil", "getTopLevelKeys"));
            }
            return collection;
        }
        List<YAMLKeyValue> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/YAMLUtil", "getTopLevelKeys"));
        }
        return list;
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInFile(YAMLFile file, List<String> key) {
        return YAMLUtil.getQualifiedKeyInDocument(file.getDocuments().get(0), key);
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInDocument(@NotNull YAMLDocument document, @NotNull List<String> key) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/yaml/YAMLUtil", "getQualifiedKeyInDocument"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/yaml/YAMLUtil", "getQualifiedKeyInDocument"));
        }
        assert (key.size() != 0);
        YAMLMapping mapping = (YAMLMapping)ObjectUtils.tryCast((Object)document.getTopLevelValue(), YAMLMapping.class);
        for (int i = 0; i < key.size(); ++i) {
            if (mapping == null) {
                return null;
            }
            YAMLKeyValue keyValue = mapping.getKeyValueByKey(key.get(i));
            if (keyValue == null || i + 1 == key.size()) {
                return keyValue;
            }
            mapping = (YAMLMapping)ObjectUtils.tryCast((Object)keyValue.getValue(), YAMLMapping.class);
        }
        throw new IllegalStateException("Should have returned from the loop");
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInFile(YAMLFile file, String ... key) {
        return YAMLUtil.getQualifiedKeyInFile(file, Arrays.asList(key));
    }

    @Nullable
    public static YAMLKeyValue findKeyInProbablyMapping(@Nullable YAMLValue node, @NotNull String keyText) {
        if (keyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyText", "org/jetbrains/yaml/YAMLUtil", "findKeyInProbablyMapping"));
        }
        if (!(node instanceof YAMLMapping)) {
            return null;
        }
        return ((YAMLMapping)node).getKeyValueByKey(keyText);
    }

    @Nullable
    public static Pair<PsiElement, String> getValue(YAMLFile file, String ... key) {
        YAMLKeyValue record = YAMLUtil.getQualifiedKeyInFile(file, key);
        if (record != null) {
            YAMLValue psiValue = record.getValue();
            return Pair.create((Object)psiValue, (Object)record.getValueText());
        }
        return null;
    }

    public YAMLKeyValue createI18nRecord(YAMLFile file, String key, String text) {
        return YAMLUtil.createI18nRecord(file, key.split("\\."), text);
    }

    @Nullable
    public static YAMLKeyValue createI18nRecord(YAMLFile file, String[] key, String text) {
        int i;
        YAMLDocument root = file.getDocuments().get(0);
        assert (root != null);
        assert (key.length > 0);
        YAMLMapping rootMapping = (YAMLMapping)PsiTreeUtil.findChildOfType((PsiElement)root, YAMLMapping.class);
        if (rootMapping == null) {
            YAMLFile yamlFile = YAMLElementGenerator.getInstance(file.getProject()).createDummyYamlWithText(key[0] + ":");
            YAMLMapping mapping = (YAMLMapping)yamlFile.getDocuments().get(0).getTopLevelValue();
            assert (mapping != null);
            rootMapping = (YAMLMapping)root.add((PsiElement)mapping);
        }
        YAMLMapping current = rootMapping;
        int keyLength = key.length;
        for (i = 0; i < keyLength; ++i) {
            YAMLMapping nextMapping;
            YAMLKeyValue existingRec = current.getKeyValueByKey(key[i]);
            if (existingRec != null && (nextMapping = (YAMLMapping)ObjectUtils.tryCast((Object)existingRec.getValue(), YAMLMapping.class)) != null) {
                current = nextMapping;
                continue;
            }
            String indent = StringUtil.repeatSymbol((char)' ', (int)YAMLUtil.getIndentInThisLine((PsiElement)current));
            StringBuilder builder = new StringBuilder();
            builder.append("---");
            for (int j = i; j < keyLength; ++j) {
                builder.append("\n").append(indent);
                builder.append(key[j]).append(":");
                indent = indent + "  ";
            }
            builder.append(" ").append(text);
            YAMLFile fileWithKey = YAMLElementGenerator.getInstance(file.getProject()).createDummyYamlWithText(builder.toString());
            YAMLMapping dummyMapping = (YAMLMapping)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)fileWithKey.getDocuments().get(0)), YAMLMapping.class);
            assert (dummyMapping != null && dummyMapping.getKeyValues().size() == 1);
            YAMLKeyValue dummyKeyValue = dummyMapping.getKeyValues().iterator().next();
            current.putKeyValue(dummyKeyValue);
            if (!(dummyKeyValue.getValue() instanceof YAMLMapping)) {
                return dummyKeyValue;
            }
            current = (YAMLMapping)dummyKeyValue.getValue();
        }
        StringBuilder builder = new StringBuilder();
        int top = Math.min(i + 1, keyLength);
        for (int j = 0; j < top; ++j) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(key[j]);
        }
        throw new IncorrectOperationException(YAMLBundle.message("new.name.conflicts.with", builder.toString()));
    }

    public static PsiElement rename(YAMLKeyValue element, String newName) {
        if (newName.contains(".")) {
            throw new IncorrectOperationException(YAMLBundle.message("rename.wrong.name"));
        }
        if (newName.equals(element.getName())) {
            throw new IncorrectOperationException(YAMLBundle.message("rename.same.name"));
        }
        YAMLKeyValue topKeyValue = YAMLElementGenerator.getInstance(element.getProject()).createYamlKeyValue(newName, "Foo");
        PsiElement key = element.getKey();
        if (key == null || topKeyValue.getKey() == null) {
            throw new IllegalStateException();
        }
        key.replace(topKeyValue.getKey());
        return element;
    }

    public static int getIndentInThisLine(@NotNull PsiElement elementInLine) {
        if (elementInLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInLine", "org/jetbrains/yaml/YAMLUtil", "getIndentInThisLine"));
        }
        PsiElement currentElement = elementInLine;
        while (currentElement != null) {
            IElementType type = currentElement.getNode().getElementType();
            if (type == YAMLTokenTypes.EOL) {
                return 0;
            }
            if (type == YAMLTokenTypes.INDENT) {
                return currentElement.getTextLength();
            }
            currentElement = PsiTreeUtil.prevLeaf((PsiElement)currentElement);
        }
        return 0;
    }

    public static int getIndentToThisElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/yaml/YAMLUtil", "getIndentToThisElement"));
        }
        int offset = element.getTextOffset();
        PsiElement currentElement = element;
        while (currentElement != null) {
            IElementType type = currentElement.getNode().getElementType();
            if (type == YAMLTokenTypes.EOL) {
                return offset - currentElement.getTextOffset() - 1;
            }
            currentElement = PsiTreeUtil.prevLeaf((PsiElement)currentElement);
        }
        return offset;
    }
}

