/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.TaskRunner;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.util.TaskUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FwTaskRunner {
    private static final Logger LOG = Logger.getInstance(FwTaskRunner.class);

    public static boolean tryFindTasksAndRun(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/FwTaskRunner", "tryFindTasksAndRun"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/FwTaskRunner", "tryFindTasksAndRun"));
        }
        if (!file.isValid()) {
            LOG.debug("Invalid file " + file.getUrl());
            return false;
        }
        if (project.isDefault() || !project.isInitialized() || project.isDisposed()) {
            return false;
        }
        if (TaskRunner.getInstance().inRefreshState(file.getUrl())) {
            return false;
        }
        List options = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<TaskOptions>>(){

            public List<TaskOptions> compute() {
                if (project.isDisposed()) {
                    return Collections.emptyList();
                }
                return ProjectTasksOptions.getInstance(project).findTasksForFile(file);
            }
        });
        if (options.isEmpty()) {
            return false;
        }
        DataContext dataContext = TaskUtils.getContext(project, file);
        Runnable runTasks = () -> TaskRunner.getInstance().runTasksForFile(dataContext, options);
        if (DumbService.isDumb((Project)project)) {
            DumbService.getInstance((Project)project).runWhenSmart(runTasks);
        } else {
            runTasks.run();
        }
        return true;
    }
}

