/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.action;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.BackgroundTaskSuppressor;
import com.intellij.plugins.watcher.config.ui.NewWatcherDialog;
import com.intellij.plugins.watcher.model.ApplicationTasksOptions;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FwEditorNotificationProvider
extends EditorNotifications.Provider {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"FwEditorNotificationProvider");
    @NotNull
    private final Project myProject;

    public FwEditorNotificationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Key getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public JComponent createNotificationPanel(@NotNull VirtualFile vFile, @NotNull FileEditor fileEditor) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider", "createNotificationPanel"));
        }
        if (!vFile.isInLocalFileSystem()) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)this.myProject).findFile(vFile);
        if (file == null) {
            return null;
        }
        BackgroundTaskConsumer[] taskConsumers = (BackgroundTaskConsumer[])BackgroundTaskConsumer.EP_NAME.getExtensions();
        if (taskConsumers.length == 0) {
            return null;
        }
        ArrayList<BackgroundTaskConsumer> toSuggest = new ArrayList<BackgroundTaskConsumer>();
        for (BackgroundTaskConsumer taskConsumer : taskConsumers) {
            if (!taskConsumer.isAvailable(file)) continue;
            TaskOptions options = taskConsumer.getOptionsTemplate();
            if (ProjectTasksOptions.getInstance(file.getProject()).isSuppressedTaskName(options.getName()) || ProjectTasksOptions.getInstance(file.getProject()).containWatcherWithFileType(options.getFileType()) || ProjectTasksOptions.getInstance(file.getProject()).findTaskByName(options.getName()) != null || BackgroundTaskSuppressor.checkSuppress(file, options)) continue;
            toSuggest.add(taskConsumer);
        }
        if (toSuggest.size() == 0) {
            return null;
        }
        if (toSuggest.size() == 1) {
            return new FwPanel(this.myProject, file, (BackgroundTaskConsumer)toSuggest.get(0));
        }
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        for (BackgroundTaskConsumer options : toSuggest) {
            panel.add((Component)((Object)new FwPanel(this.myProject, file, options)));
        }
        return panel;
    }

    private static void addFileWatcher(@NotNull Project project, @NotNull PsiFile file, @NotNull BackgroundTaskConsumer taskConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider", "addFileWatcher"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider", "addFileWatcher"));
        }
        if (taskConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskConsumer", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider", "addFileWatcher"));
        }
        TaskOptions options = taskConsumer.getOptionsTemplate();
        Pair<TaskOptions, Boolean> lastTask = ApplicationTasksOptions.getInstance().findTaskByName(options.getName());
        TaskOptions lastOptions = lastTask != null ? (TaskOptions)lastTask.getFirst() : null;
        taskConsumer.additionalConfiguration(project, file, options);
        taskConsumer.configureWithLastOptions(options, lastOptions);
        NewWatcherDialog dialog = new NewWatcherDialog(project, options, BackgroundTaskBundle.message("new.task", new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        TaskOptions newOptions = dialog.getTaskOptions();
        ApplicationTasksOptions.getInstance().addOrUpdate(Collections.singletonList(Pair.create((Object)newOptions, (Object)true)));
        ProjectTasksOptions.getInstance(project).addTask(newOptions, true);
    }

    private static class FwPanel
    extends EditorNotificationPanel {
        public FwPanel(final @NotNull Project project, @NotNull PsiFile file, @NotNull BackgroundTaskConsumer taskConsumer) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel", "<init>"));
            }
            if (taskConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskConsumer", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel", "<init>"));
            }
            super(EditorColors.GUTTER_BACKGROUND);
            String fileWatcherLinkText = "File Watcher";
            HoverHyperlinkLabel fileWatcherLink = new HoverHyperlinkLabel("File Watcher");
            fileWatcherLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, BackgroundTaskBundle.message("settings.name", new Object[0]));
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                }
            });
            NonOpaquePanel questionPanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUI.scale((int)0)));
            String message = taskConsumer.getConsumeMessage();
            int linkIndex = message.indexOf("File Watcher");
            if (linkIndex < 0) {
                questionPanel.add((Component)new JBLabel(message));
            } else {
                questionPanel.add((Component)new JBLabel(message.substring(0, linkIndex)));
                questionPanel.add((Component)fileWatcherLink);
                questionPanel.add((Component)new JBLabel(message.substring(linkIndex + "File Watcher".length())));
            }
            this.add((Component)questionPanel, "West");
            this.createActionLabel("Yes", () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel", "lambda$new$0"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel", "lambda$new$0"));
                }
                if (taskConsumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskConsumer", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel", "lambda$new$0"));
                }
                FwEditorNotificationProvider.addFileWatcher(project, file, taskConsumer);
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
            this.createActionLabel("No", () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel", "lambda$new$1"));
                }
                if (taskConsumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskConsumer", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel", "lambda$new$1"));
                }
                ProjectTasksOptions.getInstance(project).suppressTaskName(taskConsumer.getOptionsTemplate().getName());
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
        }
    }
}

