/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.FwTaskRunner;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import java.util.ArrayList;

public class RunWatchersForFileAction
extends AnAction {
    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        boolean enabled = files != null && project != null && RunWatchersForFileAction.hasDirOrTasks(project, files);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    private static boolean hasDirOrTasks(Project project, VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!file.isDirectory() && ProjectTasksOptions.getInstance(project).findTasksForFile(file).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (files == null || project == null) {
            return;
        }
        final ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
                index.iterateContentUnderDirectory(file, new ContentIterator(){

                    public boolean processFile(VirtualFile descendant) {
                        if (!descendant.isDirectory()) {
                            filesList.add(descendant);
                        }
                        return true;
                    }
                });
                continue;
            }
            filesList.add(file);
        }
        for (VirtualFile virtualFile : filesList) {
            FwTaskRunner.tryFindTasksAndRun(project, virtualFile);
        }
    }
}

