/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.google.common.collect.ImmutableMap;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.FileTypeBackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackgroundTaskConsumer {
    public static final ExtensionPointName<BackgroundTaskConsumer> EP_NAME = ExtensionPointName.create((String)"com.intellij.plugins.watcher.consumer");

    public abstract boolean isAvailable(@NotNull PsiFile var1);

    @NotNull
    public abstract TaskOptions getOptionsTemplate();

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/config/BackgroundTaskConsumer", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/plugins/watcher/config/BackgroundTaskConsumer", "additionalConfiguration"));
        }
    }

    public String getConsumeMessage() {
        TaskOptions options = this.getOptionsTemplate();
        return StringUtil.isEmpty((String)options.getDescription()) ? BackgroundTaskBundle.message("available.for.file", options.getName()) : BackgroundTaskBundle.message("available.for.file.with.description", options.getName(), options.getDescription());
    }

    public void configureWithLastOptions(TaskOptions options, @Nullable TaskOptions defaultOptions) {
        boolean noProgram = StringUtil.isEmpty((String)options.getProgram());
        if (noProgram && defaultOptions != null) {
            options.setProgram(defaultOptions.getProgram());
        }
    }

    @Nullable
    public static String findExecutableInPath(String executableName) {
        File executableFile = PathEnvironmentVariableUtil.findInPath((String)executableName);
        return executableFile != null ? executableFile.getAbsolutePath() : null;
    }

    @Nullable
    public static FileTypeBackgroundTaskConsumer findConsumerByFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/plugins/watcher/config/BackgroundTaskConsumer", "findConsumerByFileType"));
        }
        return (FileTypeBackgroundTaskConsumer)ConsumerMapHolder.CONSUMER_BY_FILE_TYPE.get(fileType);
    }

    private static class ConsumerMapHolder {
        private static final Map<FileType, FileTypeBackgroundTaskConsumer> CONSUMER_BY_FILE_TYPE;

        private ConsumerMapHolder() {
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (BackgroundTaskConsumer consumer : (BackgroundTaskConsumer[])EP_NAME.getExtensions()) {
                FileTypeBackgroundTaskConsumer fileTypeConsumer = (FileTypeBackgroundTaskConsumer)ObjectUtils.tryCast((Object)consumer, FileTypeBackgroundTaskConsumer.class);
                if (fileTypeConsumer == null) continue;
                builder.put((Object)fileTypeConsumer.getFileType(), (Object)fileTypeConsumer);
            }
            CONSUMER_BY_FILE_TYPE = builder.build();
        }
    }
}

