/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.problems.FwOutputSettings;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTypeBackgroundTaskConsumer
extends BackgroundTaskConsumer {
    private final FileType myFileType;

    protected FileTypeBackgroundTaskConsumer(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/plugins/watcher/config/FileTypeBackgroundTaskConsumer", "<init>"));
        }
        this.myFileType = fileType;
    }

    @Override
    public boolean isAvailable(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/plugins/watcher/config/FileTypeBackgroundTaskConsumer", "isAvailable"));
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null) {
            return this.isAvailable(virtualFile, EnvironmentVariablesData.DEFAULT);
        }
        return false;
    }

    public boolean isAvailable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/config/FileTypeBackgroundTaskConsumer", "isAvailable"));
        }
        return this.isAvailable(file, EnvironmentVariablesData.DEFAULT);
    }

    public boolean isAvailable(@NotNull VirtualFile file, @NotNull EnvironmentVariablesData data) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/config/FileTypeBackgroundTaskConsumer", "isAvailable"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/plugins/watcher/config/FileTypeBackgroundTaskConsumer", "isAvailable"));
        }
        return file.getFileType() == this.myFileType;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/config/FileTypeBackgroundTaskConsumer", "getFileType"));
        }
        return fileType;
    }

    @Nullable
    public String getTrackOnlyRootFilesLabel() {
        return null;
    }

    @NotNull
    public FwOutputSettings getOutputSettings() {
        FwOutputSettings fwOutputSettings = FwOutputSettings.DEFAULT;
        if (fwOutputSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/config/FileTypeBackgroundTaskConsumer", "getOutputSettings"));
        }
        return fwOutputSettings;
    }
}

