/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config.ui;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.FileTypeBackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.OutputFiltersDialog;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewWatcherDialog
extends DialogWrapper {
    private final Project myProject;
    private JPanel myMainPanel;
    private JTextField myNameField;
    private JButton myDirInsertMacroButton;
    private TextFieldWithBrowseButton myProgramField;
    private TextFieldWithBrowseButton myWorkingDirField;
    private RawCommandLineEditor myArgumentsField;
    private JCheckBox myTrackOnlyRootFilesCheckBox;
    private JButton myArgumentsInserMacroBtn;
    private ScopeChooserCombo myScopeCombo;
    private JTextField myOutputField;
    private JButton myOutputInsertMacroBtn;
    private JCheckBox myOutputFromStdout;
    private EnvironmentVariablesComponent myEnvComponent;
    private JComboBox myFileTypesCombo;
    private JButton myFiltersBtn;
    private JComboBox myBehaviourComboBox;
    private JCheckBox myTriggerWatcherRegardlessSyntaxErrorsCheckBox;
    private JCheckBox myImmediateFileSynchronizationCheckBox;
    private JBLabel myNoSuchFilesInScopeErrorLabel;
    private JBLabel myProgramNotFoundErrorLabel;
    private AbstractTitledSeparatorWithIcon myAdvancedOptionsSeparator;
    private JPanel myAdvancedOptionsPanel;
    private FilterInfo[] myOutputFilters;

    public NewWatcherDialog(@NotNull Project project, TaskOptions options, String title) {
        String trackOnlyRootFilesTitle;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/watcher/config/ui/NewWatcherDialog", "<init>"));
        }
        super(true);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setTitle(title);
        this.myArgumentsInserMacroBtn.addActionListener(new InsertMacroActionListener(this.myArgumentsField.getTextField()));
        this.myDirInsertMacroButton.addActionListener(new InsertMacroActionListener(this.myWorkingDirField.getTextField()));
        this.myOutputInsertMacroBtn.addActionListener(new InsertMacroActionListener(this.myOutputField));
        this.myProgramField.addBrowseFolderListener(null, null, project, new FileChooserDescriptor(true, true, true, true, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return super.isFileSelectable(file) || SystemInfo.isMac && file.isDirectory() && "app".equals(file.getExtension());
            }
        });
        this.myWorkingDirField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myFiltersBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputFiltersDialog dialog = new OutputFiltersDialog((Component)NewWatcherDialog.this.myFiltersBtn, NewWatcherDialog.this.myOutputFilters);
                if (dialog.showAndGet()) {
                    NewWatcherDialog.access$102(NewWatcherDialog.this, dialog.getData());
                }
            }
        });
        for (TaskOptions.ExitCodeBehavior behavior : TaskOptions.ExitCodeBehavior.values()) {
            ((DefaultComboBoxModel)this.myBehaviourComboBox.getModel()).addElement(behavior);
        }
        this.myBehaviourComboBox.setRenderer(new ListCellRendererWrapper<TaskOptions.ExitCodeBehavior>(){

            public void customize(JList list, TaskOptions.ExitCodeBehavior value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getDisplayName());
            }
        });
        this.myScopeCombo.setShowEmptyScopes(true);
        this.myScopeCombo.setCurrentSelection(false);
        this.myEnvComponent.remove((Component)this.myEnvComponent.getLabel());
        this.myFileTypesCombo.setRenderer(new FileTypeRenderer());
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Arrays.sort(fileTypes, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        ((DefaultComboBoxModel)this.myFileTypesCombo.getModel()).addElement(TaskUtils.FAKE_ANY_FILE_TYPE);
        for (FileType type : fileTypes) {
            ((DefaultComboBoxModel)this.myFileTypesCombo.getModel()).addElement(type);
        }
        new ComboboxSpeedSearch(this.myFileTypesCombo){

            protected String getElementText(Object element) {
                return ((FileType)element).getName();
            }
        };
        FileTypeBackgroundTaskConsumer consumer = BackgroundTaskConsumer.findConsumerByFileType(options.getFileType());
        if (consumer != null && (trackOnlyRootFilesTitle = consumer.getTrackOnlyRootFilesLabel()) != null) {
            this.myTrackOnlyRootFilesCheckBox.setText(trackOnlyRootFilesTitle);
        }
        this.myFileTypesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileType fileType = (FileType)NewWatcherDialog.this.myFileTypesCombo.getSelectedItem();
                NewWatcherDialog.this.myTrackOnlyRootFilesCheckBox.setEnabled(TaskUtils.findDependencyFinderForExtension(fileType.getDefaultExtension()) != null);
            }
        });
        this.myFileTypesCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewWatcherDialog.this.updateMatchedFilesInfo();
            }
        });
        ((JComboBox)this.myScopeCombo.getChildComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewWatcherDialog.this.updateMatchedFilesInfo();
            }
        });
        this.myProgramField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NewWatcherDialog.this.updateProgramNotFoundErrorLabel();
            }
        });
        this.myNoSuchFilesInScopeErrorLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myProgramNotFoundErrorLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myAdvancedOptionsPanel.setVisible(false);
        this.myArgumentsField.setDialogCaption("Program Arguments");
        this.setTaskOptions(options);
        this.updateMatchedFilesInfo();
        this.updateProgramNotFoundErrorLabel();
        this.init();
    }

    private void updateMatchedFilesInfo() {
        Collection files;
        FileType fileType = (FileType)this.myFileTypesCombo.getSelectedItem();
        if (fileType == UnknownFileType.INSTANCE) {
            this.myNoSuchFilesInScopeErrorLabel.setText(BackgroundTaskBundle.message("unknown.file.type", new Object[0]));
            this.myNoSuchFilesInScopeErrorLabel.setVisible(true);
            return;
        }
        SearchScope selectedScope = this.myScopeCombo.getSelectedScope();
        if (fileType != TaskUtils.FAKE_ANY_FILE_TYPE && selectedScope instanceof GlobalSearchScope && (files = FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)((GlobalSearchScope)selectedScope))).isEmpty()) {
            this.myNoSuchFilesInScopeErrorLabel.setText(BackgroundTaskBundle.message("no.such.files.in.scope", new Object[0]));
            this.myNoSuchFilesInScopeErrorLabel.setVisible(true);
            return;
        }
        this.myNoSuchFilesInScopeErrorLabel.setVisible(false);
    }

    private void updateProgramNotFoundErrorLabel() {
        String error = NewWatcherDialog.getErrorMessageIfBadProgram(this.myProgramField.getText());
        if (error == null) {
            this.myProgramField.getTextField().setForeground(UIUtil.getLabelForeground());
            this.myProgramNotFoundErrorLabel.setVisible(false);
        } else {
            this.myProgramField.getTextField().setForeground((Color)JBColor.RED);
            this.myProgramNotFoundErrorLabel.setText(error);
            this.myProgramNotFoundErrorLabel.setVisible(true);
        }
    }

    private void createUIComponents() {
        this.myAdvancedOptionsSeparator = new AbstractTitledSeparatorWithIcon(AllIcons.General.ComboArrowRight, AllIcons.General.ComboArrowDown, "Other Options"){

            protected RefreshablePanel createPanel() {
                return new RefreshablePanel(){

                    public void refresh() {
                    }

                    public JPanel getPanel() {
                        return new JPanel();
                    }
                };
            }

            protected void initOnImpl() {
            }

            protected void onImpl() {
                NewWatcherDialog.this.myAdvancedOptionsPanel.setVisible(true);
            }

            protected void offImpl() {
                NewWatcherDialog.this.myAdvancedOptionsPanel.setVisible(false);
            }
        };
    }

    @Nullable
    private static String getErrorMessageIfBadProgram(@NotNull String program) {
        if (program == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "program", "com/intellij/plugins/watcher/config/ui/NewWatcherDialog", "getErrorMessageIfBadProgram"));
        }
        if (StringUtil.isEmptyOrSpaces((String)program)) {
            return "Program not set";
        }
        File file = new File(program);
        if (file.isAbsolute()) {
            if (!file.exists()) {
                return "File not found";
            }
            if (!(!file.isDirectory() || SystemInfo.isMac && program.endsWith(".app"))) {
                return "Folder specified";
            }
        } else if (PathEnvironmentVariableUtil.findInPath((String)program) == null) {
            return "File not found";
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "EditFileWatcherDialog";
    }

    public TaskOptions getTaskOptions() {
        TaskOptions options = new TaskOptions();
        options.setName(this.myNameField.getText());
        FileType fileType = (FileType)this.myFileTypesCombo.getSelectedItem();
        String defaultExtension = fileType.getDefaultExtension();
        options.setFileExtension(StringUtil.isEmpty((String)defaultExtension) ? fileType.getName() : defaultExtension);
        options.setScopeName(this.myScopeCombo.getSelectedScopeName());
        options.setProgram(this.myProgramField.getText());
        options.setArguments(this.myArgumentsField.getText());
        options.setWorkingDir(this.myWorkingDirField.getText());
        options.setOutput(this.myOutputField.getText());
        options.setTrackOnlyRoot(this.myTrackOnlyRootFilesCheckBox.isSelected());
        options.setImmediateSync(this.myImmediateFileSynchronizationCheckBox.isSelected());
        options.setCheckSyntaxErrors(!this.myTriggerWatcherRegardlessSyntaxErrorsCheckBox.isSelected());
        options.setOutputFromStdout(this.myOutputFromStdout.isSelected());
        options.setEnvData(this.myEnvComponent.getEnvData());
        options.setOutputFilters(this.myOutputFilters);
        options.setExitCodeBehavior((TaskOptions.ExitCodeBehavior)((Object)this.myBehaviourComboBox.getSelectedItem()));
        return options;
    }

    public void setTaskOptions(TaskOptions options) {
        this.myNameField.setText(StringUtil.notNullize((String)options.getName()));
        this.myFileTypesCombo.setSelectedItem(options.getFileType());
        this.myScopeCombo.init(this.myProject, options.getScopeName());
        this.myProgramField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)options.getProgram())));
        this.myArgumentsField.setText(options.getArguments());
        this.myWorkingDirField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)options.getWorkingDir())));
        this.myOutputField.setText(options.getOutput());
        this.myTrackOnlyRootFilesCheckBox.setSelected(options.isTrackOnlyRoot());
        this.myTriggerWatcherRegardlessSyntaxErrorsCheckBox.setSelected(!options.isCheckSyntaxErrors());
        this.myImmediateFileSynchronizationCheckBox.setSelected(options.isImmediateSync());
        this.myOutputFromStdout.setSelected(options.isOutputFromStdout());
        this.myEnvComponent.setEnvData(options.getEnvData());
        this.myOutputFilters = options.getOutputFilters();
        this.myBehaviourComboBox.setSelectedItem((Object)options.getExitCodeBehavior());
    }

    @Nullable
    protected String getHelpId() {
        return "settings.project.settings.file.watchers.new.watcher";
    }

    static /* synthetic */ FilterInfo[] access$102(NewWatcherDialog x0, FilterInfo[] x1) {
        x0.myOutputFilters = x1;
        return x1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        EnvironmentVariablesComponent environmentVariablesComponent;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JButton jButton2;
        JTextField jTextField;
        JButton jButton3;
        RawCommandLineEditor rawCommandLineEditor;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        ScopeChooserCombo scopeChooserCombo;
        JBLabel jBLabel2;
        JComboBox jComboBox;
        JTextField jTextField2;
        JButton jButton4;
        JComboBox jComboBox2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Options", (int)0, (int)0, null, null));
        this.myTriggerWatcherRegardlessSyntaxErrorsCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("check.syntax.errors"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTrackOnlyRootFilesCheckBox = jCheckBox3 = new JCheckBox();
        ((Component)jCheckBox3).setEnabled(false);
        jCheckBox3.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("settings.track.only.root.files"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myImmediateFileSynchronizationCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("immediate.synchronization"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Show console: ");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBehaviourComboBox = jComboBox2 = new JComboBox();
        jPanel4.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myFiltersBtn = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("messages/ToolsBundle").getString("tools.filters.button"));
        jPanel3.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Name:");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Watched Files", (int)0, (int)0, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("File type:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(5);
        jPanel5.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileTypesCombo = jComboBox = new JComboBox();
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myNoSuchFilesInScopeErrorLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("no.such.files.in.scope"));
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 2, 2, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Scope:");
        jLabel4.setDisplayedMnemonic('S');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScopeCombo = scopeChooserCombo = new ScopeChooserCombo();
        jPanel5.add((Component)scopeChooserCombo, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Watcher Settings", (int)0, (int)0, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Program:");
        jLabel5.setDisplayedMnemonic('P');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProgramField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myProgramNotFoundErrorLabel = jBLabel = new JBLabel();
        jBLabel.setText("File not found");
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Arguments:");
        jLabel6.setDisplayedMnemonic('A');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myArgumentsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel6.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myArgumentsInserMacroBtn = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("settings.insert.macro"));
        jPanel6.add((Component)jButton3, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Output paths to refresh:");
        jLabel7.setDisplayedMnemonic('O');
        jLabel7.setDisplayedMnemonicIndex(0);
        jLabel7.setToolTipText("Files where the program stores its output. Used by the IDE to detect generated files. ");
        jPanel6.add((Component)jLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputField = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        this.myOutputInsertMacroBtn = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("settings.insert.macro"));
        jPanel6.add((Component)jButton2, new GridConstraints(2, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel7, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        AbstractTitledSeparatorWithIcon abstractTitledSeparatorWithIcon = this.myAdvancedOptionsSeparator;
        jPanel7.add((Component)abstractTitledSeparatorWithIcon, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myAdvancedOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Working directory:");
        jLabel8.setDisplayedMnemonic('W');
        jLabel8.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkingDirField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myDirInsertMacroButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("settings.insert.macro"));
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEnvComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("East");
        environmentVariablesComponent.setText("");
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Environment variables:");
        jLabel9.setDisplayedMnemonic('E');
        jLabel9.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel9, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputFromStdout = jCheckBox = new JCheckBox();
        jCheckBox.setText("Create output file from stdout");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jComboBox);
        jLabel4.setLabelFor((Component)scopeChooserCombo);
        jLabel5.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel6.setLabelFor((Component)rawCommandLineEditor);
        jLabel7.setLabelFor(jTextField);
        jLabel8.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel9.setLabelFor((Component)environmentVariablesComponent);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class InsertMacroActionListener
    implements ActionListener {
        private final JTextField myTextField;

        public InsertMacroActionListener(JTextField textField) {
            this.myTextField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MacrosDialog dialog = new MacrosDialog(NewWatcherDialog.this.myProject);
            if (dialog.showAndGet() && dialog.getSelectedMacro() != null) {
                String macro = dialog.getSelectedMacro().getName();
                int position = this.myTextField.getCaretPosition();
                try {
                    this.myTextField.getDocument().insertString(position, "$" + macro + "$", null);
                    this.myTextField.setCaretPosition(position + macro.length() + 2);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            IdeFocusManager.findInstance().requestFocus((Component)this.myTextField, true);
        }
    }
}

