/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.TaskProblemsHolder;
import com.intellij.plugins.watcher.TaskRunner;
import com.intellij.plugins.watcher.inspections.TaskInspectionBase;
import com.intellij.plugins.watcher.problems.TaskProblemDescription;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskProblemsInspection
extends TaskInspectionBase {
    @NotNull
    public String getShortName() {
        String string = TaskProblemsInspection.getInspectionShortName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "getShortName"));
        }
        return string;
    }

    @NotNull
    public static String getInspectionShortName() {
        if ("TaskProblemsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "getInspectionShortName"));
        }
        return "TaskProblemsInspection";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("File watcher problems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "getDisplayName"));
        }
        return "File watcher problems";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<TaskProblemDescription> descriptions;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "checkFile"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        TaskProblemsHolder problemsHolder = TaskRunner.getInstance().getProblemsHolder();
        List<TaskProblemDescription> list = descriptions = virtualFile != null ? problemsHolder.findProblems(file) : Collections.emptyList();
        if (descriptions.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>(descriptions.size());
        for (TaskProblemDescription description : descriptions) {
            ProblemDescriptor descriptor = TaskProblemsInspection.createProblemDescriptor(description, file, manager, isOnTheFly);
            if (descriptor == null) continue;
            descriptors.add(descriptor);
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    @Nullable
    private static ProblemDescriptor createProblemDescriptor(TaskProblemDescription taskProblemDescription, @NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement element;
        int lineStartOffset;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "createProblemDescriptor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "createProblemDescriptor"));
        }
        Document document = file.getViewProvider().getDocument();
        Integer line = taskProblemDescription.getLine();
        if (document == null || line == null) {
            return null;
        }
        if (0 > line || line >= document.getLineCount()) {
            return null;
        }
        int errorStartOffset = lineStartOffset = document.getLineStartOffset(line.intValue());
        boolean afterEndOfLine = false;
        if (taskProblemDescription.getColumn() != null) {
            int lineEndOffset = document.getLineEndOffset(line.intValue());
            boolean bl = afterEndOfLine = (errorStartOffset += taskProblemDescription.getColumn().intValue()) == lineEndOffset;
        }
        if ((element = file.findElementAt(errorStartOffset)) == null && lineStartOffset < errorStartOffset) {
            element = file.findElementAt(errorStartOffset - 1);
        }
        if (element != null) {
            if (afterEndOfLine) {
                element = TaskProblemsInspection.findLastElementInLine(element, document, line);
            }
            String message = taskProblemDescription.getMessage();
            ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (message != null && StringUtil.containsIgnoreCase((String)message, (String)"error")) {
                highlightType = ProblemHighlightType.GENERIC_ERROR;
            }
            String descriptionMessage = TaskProblemsInspection.createDescription(message);
            return manager.createProblemDescriptor(element, descriptionMessage, LocalQuickFix.EMPTY_ARRAY, highlightType, isOnTheFly, afterEndOfLine);
        }
        return null;
    }

    @NotNull
    private static String createDescription(@Nullable String message) {
        if (StringUtil.isEmpty((String)message)) {
            String string = BackgroundTaskBundle.message("inspection.empty.message", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "createDescription"));
            }
            return string;
        }
        if (message.contains("\n")) {
            String string = "<html><body><pre>" + message + "</pre></body></html>";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "createDescription"));
            }
            return string;
        }
        String string = message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "createDescription"));
        }
        return string;
    }

    @NotNull
    private static PsiElement findLastElementInLine(@NotNull PsiElement initialElement, @NotNull Document document, int documentLine) {
        if (initialElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialElement", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "findLastElementInLine"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "findLastElementInLine"));
        }
        PsiElement element = PsiTreeUtil.lastChild((PsiElement)initialElement);
        while (element != null) {
            if (!(element instanceof PsiErrorElement) && element.getTextLength() > 0) {
                int endOffset = element.getTextRange().getEndOffset();
                if (endOffset < 0 || document.getTextLength() < endOffset) {
                    throw new AssertionError((Object)"Element end offset is out of document");
                }
                int endLineNumber = document.getLineNumber(endOffset);
                if (endLineNumber == documentLine) {
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "findLastElementInLine"));
                    }
                    return psiElement;
                }
                if (endLineNumber < documentLine) {
                    PsiElement psiElement = initialElement;
                    if (psiElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "findLastElementInLine"));
                    }
                    return psiElement;
                }
            }
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        PsiElement psiElement = initialElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/inspections/TaskProblemsInspection", "findLastElementInLine"));
        }
        return psiElement;
    }
}

