/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.FwTaskConfigurationListener;
import com.intellij.plugins.watcher.config.FileWatchersState;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.model.TasksPersistentComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectTasksOptions", storages={@Storage(value="watcherTasks.xml")})
public class ProjectTasksOptions
extends TasksPersistentComponent {
    private final Project myProject;
    private volatile List<String> mySuppressedTaskNames = Collections.emptyList();
    private volatile Set<String> mySuppressedTaskNameSet = Collections.emptySet();
    private volatile Set<FileType> myConfiguredWatcherFileTypes = Collections.emptySet();
    private final List<FwTaskConfigurationListener> myTaskConfigurationListeners = ContainerUtil.createEmptyCOWList();

    public static ProjectTasksOptions getInstance(Project project) {
        return (ProjectTasksOptions)ServiceManager.getService((Project)project, ProjectTasksOptions.class);
    }

    public ProjectTasksOptions(Project project) {
        this.myProject = project;
    }

    public void addTaskConfigurationListener(@NotNull FwTaskConfigurationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "addTaskConfigurationListener"));
        }
        this.myTaskConfigurationListeners.add(listener);
    }

    @Override
    public void setTasks(List<Pair<TaskOptions, Boolean>> tasks) {
        super.setTasks(tasks);
        this.onTasksUpdated(tasks);
    }

    @Override
    public void addTask(TaskOptions options, boolean isEnabled) {
        super.addTask(options, isEnabled);
        this.onTasksUpdated(this.getTasks());
    }

    private void onTasksUpdated(@NotNull List<Pair<TaskOptions, Boolean>> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "onTasksUpdated"));
        }
        this.myConfiguredWatcherFileTypes = ImmutableSet.copyOf((Collection)ContainerUtil.map(tasks, pair -> ((TaskOptions)pair.getFirst()).getFileType()));
        this.fireConfigurationEvents(tasks);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private void fireConfigurationEvents(@NotNull List<Pair<TaskOptions, Boolean>> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "fireConfigurationEvents"));
        }
        boolean hasEnabledTasks = ProjectTasksOptions.hasEnabledTasks(tasks);
        boolean hasEnabledTasksWithImmediateSync = ProjectTasksOptions.hasEnabledTasksWithImmediateSync(tasks);
        UIUtil.invokeLaterIfNeeded(() -> {
            for (FwTaskConfigurationListener listener : this.myTaskConfigurationListeners) {
                listener.taskConfigurationChanged(hasEnabledTasks, hasEnabledTasksWithImmediateSync);
            }
        });
    }

    public boolean hasEnabledTasks() {
        return ProjectTasksOptions.hasEnabledTasks(this.getTasks());
    }

    private static boolean hasEnabledTasks(@NotNull List<Pair<TaskOptions, Boolean>> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "hasEnabledTasks"));
        }
        for (Pair<TaskOptions, Boolean> task : tasks) {
            if (!Boolean.TRUE.equals(task.getSecond())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnabledTasksWithImmediateSync() {
        return ProjectTasksOptions.hasEnabledTasksWithImmediateSync(this.getTasks());
    }

    private static boolean hasEnabledTasksWithImmediateSync(@NotNull List<Pair<TaskOptions, Boolean>> pairs) {
        if (pairs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pairs", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "hasEnabledTasksWithImmediateSync"));
        }
        for (Pair<TaskOptions, Boolean> pair : pairs) {
            if (!Boolean.TRUE.equals(pair.getSecond()) || !((TaskOptions)pair.getFirst()).isImmediateSync()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<String> getSuppressedTaskNames() {
        List<String> list = this.mySuppressedTaskNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "getSuppressedTaskNames"));
        }
        return list;
    }

    @Override
    public void setSuppressedTaskNames(@NotNull List<String> suppressedTaskNames) {
        if (suppressedTaskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suppressedTaskNames", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "setSuppressedTaskNames"));
        }
        ImmutableList immutableList = ImmutableList.copyOf(suppressedTaskNames);
        ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)immutableList);
        this.mySuppressedTaskNames = immutableList;
        this.mySuppressedTaskNameSet = immutableSet;
        if (immutableSet.size() != immutableList.size()) {
            ArrayList mutableCopy = ContainerUtil.newArrayList((Iterable)immutableList);
            ContainerUtil.removeDuplicates((Collection)mutableCopy);
            this.mySuppressedTaskNames = ImmutableList.copyOf((Collection)mutableCopy);
            this.mySuppressedTaskNameSet = ImmutableSet.copyOf((Collection)mutableCopy);
        }
    }

    @Override
    public void setEnabledForTask(String name, boolean isEnabled) {
        super.setEnabledForTask(name, isEnabled);
    }

    @NotNull
    public List<TaskOptions> findTasksForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "findTasksForFile"));
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file) || Comparing.equal((CharSequence)file.getNameSequence(), (CharSequence)"npm-debug.log", (boolean)SystemInfoRt.isFileSystemCaseSensitive)) {
            List<TaskOptions> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "findTasksForFile"));
            }
            return list;
        }
        ArrayList<TaskOptions> result = null;
        for (Pair<TaskOptions, Boolean> task : this.getTasks()) {
            TaskOptions options;
            boolean enabled = (Boolean)task.getSecond();
            if (!enabled || !(options = (TaskOptions)task.getFirst()).getFileScope(this.myProject).contains(file)) continue;
            if (result == null) {
                result = new ArrayList<TaskOptions>();
            }
            result.add(options);
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "findTasksForFile"));
        }
        return list;
    }

    public boolean containWatcherWithFileType(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "containWatcherWithFileType"));
        }
        return this.myConfiguredWatcherFileTypes.contains(type);
    }

    public boolean isEnabled(String name) {
        Pair<TaskOptions, Boolean> taskByName = this.findTaskByName(name);
        return taskByName != null && (Boolean)taskByName.getSecond() != false;
    }

    @NotNull
    public FileWatchersState getWatchersState() {
        FileWatchersState fileWatchersState = new FileWatchersState(this.getTasks(), this.mySuppressedTaskNames);
        if (fileWatchersState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "getWatchersState"));
        }
        return fileWatchersState;
    }

    public void setWatchersState(@NotNull FileWatchersState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "setWatchersState"));
        }
        this.setTasks(state.getTasks());
        this.setSuppressedTaskNames((List<String>)state.getSuppressedTaskNames());
    }

    public boolean isSuppressedTaskName(@NotNull String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "isSuppressedTaskName"));
        }
        return this.mySuppressedTaskNameSet.contains(taskName);
    }

    public void suppressTaskName(@NotNull String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "suppressTaskName"));
        }
        if (!this.isSuppressedTaskName(taskName)) {
            ArrayList list = ContainerUtil.newArrayList(this.mySuppressedTaskNames);
            list.add(taskName);
            this.setSuppressedTaskNames(list);
        }
    }

    public boolean containsTask(@NotNull TaskOptions taskOptions) {
        if (taskOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskOptions", "com/intellij/plugins/watcher/model/ProjectTasksOptions", "containsTask"));
        }
        List<Pair<TaskOptions, Boolean>> tasks = this.getTasks();
        for (Pair<TaskOptions, Boolean> taskPair : tasks) {
            if (!((TaskOptions)taskPair.getFirst()).equals(taskOptions)) continue;
            return true;
        }
        return false;
    }
}

