/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.util;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.concurrent.ConcurrentLinkedQueue;

public class HistoryProcessListener
extends ProcessAdapter {
    private ConcurrentLinkedQueue<Pair<ProcessEvent, Key>> myHistory = new ConcurrentLinkedQueue();
    private boolean myCommandLineSkipped = false;

    public void onTextAvailable(ProcessEvent event, Key outputType) {
        boolean add = true;
        if (outputType == ProcessOutputTypes.SYSTEM) {
            add = this.myCommandLineSkipped;
            this.myCommandLineSkipped = true;
        }
        if (add) {
            this.myHistory.add((Pair<ProcessEvent, Key>)Pair.create((Object)event, (Object)outputType));
        }
    }

    public void apply(ProcessHandler listener) {
        for (Pair<ProcessEvent, Key> pair : this.myHistory) {
            listener.notifyTextAvailable(((ProcessEvent)pair.getFirst()).getText(), (Key)pair.getSecond());
        }
    }
}

