/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.util;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchedFile {
    private final VirtualFile mySourceFile;
    private final List<GeneratedFile> myGeneratedFiles;

    public WatchedFile(@NotNull VirtualFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/plugins/watcher/util/WatchedFile", "<init>"));
        }
        this.myGeneratedFiles = new ArrayList<GeneratedFile>(2);
        this.mySourceFile = sourceFile;
    }

    public void addUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/plugins/watcher/util/WatchedFile", "addUrl"));
        }
        this.myGeneratedFiles.add(new GeneratedFile(url, null));
    }

    @NotNull
    public VirtualFile getSourceFile() {
        VirtualFile virtualFile = this.mySourceFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/util/WatchedFile", "getSourceFile"));
        }
        return virtualFile;
    }

    @NotNull
    public List<GeneratedFile> getGeneratedFiles() {
        List<GeneratedFile> list = this.myGeneratedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/util/WatchedFile", "getGeneratedFiles"));
        }
        return list;
    }

    public static class GeneratedFile {
        private final String myUrl;
        private VirtualFile myFile;

        public GeneratedFile(@NotNull String url, @Nullable VirtualFile file) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/plugins/watcher/util/WatchedFile$GeneratedFile", "<init>"));
            }
            this.myUrl = url;
            this.myFile = file;
        }

        @NotNull
        public String getUrl() {
            String string = this.myUrl;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/util/WatchedFile$GeneratedFile", "getUrl"));
            }
            return string;
        }

        @Nullable
        public VirtualFile getFile() {
            return this.myFile;
        }

        public void setFile(@Nullable VirtualFile file) {
            this.myFile = file;
        }
    }
}

