/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.descriptor.value.CssValueValidatorStub;
import com.intellij.psi.css.resolve.CssStyleReferenceStub;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssElementDescriptorProvider {
    public static final ExtensionPointName<CssElementDescriptorProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.css.elementDescriptorProvider");
    private static final CssValueValidatorStub VALUE_VALIDATOR_STUB = new CssValueValidatorStub();

    public abstract boolean isMyContext(@Nullable PsiElement var1);

    public boolean shouldAskOtherProviders(@Nullable PsiElement context) {
        return true;
    }

    @Nullable
    public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/CssElementDescriptorProvider", "getPropertyDescriptor"));
        }
        return (CssPropertyDescriptor)ContainerUtil.getFirstItem(this.findPropertyDescriptors(propertyName, context));
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/CssElementDescriptorProvider", "findPseudoSelectorDescriptors"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "findPseudoSelectorDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/CssElementDescriptorProvider", "getNamedValueDescriptors"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "getNamedValueDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/CssElementDescriptorProvider", "findPropertyDescriptors"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "findPropertyDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/CssElementDescriptorProvider", "findFunctionDescriptors"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "findFunctionDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssMediaFeatureDescriptor> findMediaFeatureDescriptors(@NotNull String mediaFeatureName, @Nullable PsiElement context) {
        if (mediaFeatureName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaFeatureName", "com/intellij/psi/css/CssElementDescriptorProvider", "findMediaFeatureDescriptors"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "findMediaFeatureDescriptors"));
        }
        return list;
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/CssElementDescriptorProvider", "isPossibleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/CssElementDescriptorProvider", "isPossibleSelector"));
        }
        return ArrayUtil.contains((String)selector, (String[])this.getSimpleSelectors(context));
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "getAllPseudoSelectorDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "getAllPropertyDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "getAllMediaFeatureDescriptors"));
        }
        return list;
    }

    @NotNull
    public String[] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/CssElementDescriptorProvider", "getSimpleSelectors"));
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "getSimpleSelectors"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public abstract PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector var1);

    public boolean providesClassicCss() {
        return true;
    }

    @Nullable
    public PsiElement getDocumentationElementForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/psi/css/CssElementDescriptorProvider", "getDocumentationElementForSelector"));
        }
        return null;
    }

    @Nullable
    public String generateDocForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/psi/css/CssElementDescriptorProvider", "generateDocForSelector"));
        }
        return null;
    }

    public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
        return new CssStyleReferenceStub(element, TextRange.create((int)start, (int)end));
    }

    @NotNull
    public CssValueValidator getValueValidator() {
        CssValueValidatorStub cssValueValidatorStub = VALUE_VALIDATOR_STUB;
        if (cssValueValidatorStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "getValueValidator"));
        }
        return cssValueValidatorStub;
    }

    @Nullable
    public Color getColorByValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/CssElementDescriptorProvider", "getColorByValue"));
        }
        return null;
    }

    public boolean isColorTerm(@NotNull CssTerm term) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/CssElementDescriptorProvider", "isColorTerm"));
        }
        return false;
    }

    @NotNull
    public LocalQuickFix[] getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/CssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/CssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public LocalQuickFix[] getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName, @NotNull PsiElement context, boolean isOnTheFly) {
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/psi/css/CssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/CssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    public boolean isColorTermsSupported() {
        return true;
    }

    public CssContextType getCssContextType(@Nullable PsiElement context) {
        return CssContextType.ANY;
    }
}

