/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CssElementDescriptor {
    @NotNull
    public CssVersion getCssVersion();

    @NotNull
    public BrowserVersion[] getBrowsers();

    public boolean isAllowedInContextType(@NotNull CssContextType var1);

    @NotNull
    public String getId();

    @NotNull
    public String getPresentableName();

    @NotNull
    public String getDescription();

    @Nullable
    public String getDocumentationString(@Nullable PsiElement var1);

    @NotNull
    public String getElementTypeName();

    @Nullable
    public String getSpecificationUrl();

    @NotNull
    public CssContextType[] getAllowedContextTypes();

    @Nullable
    public Icon getIcon();

    public static enum CssVersion {
        UNKNOWN("UNKNOWN", 0),
        CSS_1("CSS 1.0", 1),
        CSS_2("CSS 2.0", 2),
        CSS_2_1("CSS 2.1", 3),
        CSS_3_0("CSS 3.0", 4),
        CSS_4_0("CSS 4.0", 5),
        CSS_3_0_MOZILLA("CSS3 Mozilla", 0),
        CSS_3_0_SAFARI("CSS3 Safari", 0),
        CSS_3_0_OPERA("CSS3 Opera", 0);

        @NotNull
        private final String myPresentableName;
        private final int myValue;

        private CssVersion(String presentableName, int myValue) {
            if (presentableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion", "<init>"));
            }
            this.myPresentableName = presentableName;
            this.myValue = myValue;
        }

        @NotNull
        public String getPresentableName() {
            String string = this.myPresentableName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion", "getPresentableName"));
            }
            return string;
        }

        @NotNull
        public static CssVersion fromString(@Nullable String string) {
            if ("1.0".equals(string)) {
                CssVersion cssVersion = CSS_1;
                if (cssVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion", "fromString"));
                }
                return cssVersion;
            }
            if ("2.0".equals(string)) {
                CssVersion cssVersion = CSS_2;
                if (cssVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion", "fromString"));
                }
                return cssVersion;
            }
            if ("2.1".equals(string)) {
                CssVersion cssVersion = CSS_2_1;
                if (cssVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion", "fromString"));
                }
                return cssVersion;
            }
            if ("3.0".equals(string)) {
                CssVersion cssVersion = CSS_3_0;
                if (cssVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion", "fromString"));
                }
                return cssVersion;
            }
            if ("4.0".equals(string)) {
                CssVersion cssVersion = CSS_4_0;
                if (cssVersion == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion", "fromString"));
                }
                return cssVersion;
            }
            CssVersion cssVersion = UNKNOWN;
            if (cssVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion", "fromString"));
            }
            return cssVersion;
        }

        public int value() {
            return this.myValue;
        }
    }
}

