/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssMediaGroupAwareDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssVersionDescriptorComparator;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.descriptor.value.CssValueValidatorStub;
import com.intellij.psi.css.resolve.CssStyleReferenceStub;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssDescriptorsUtil {
    public static final NotNullFunction<CssElementDescriptor, String> GET_DESCRIPTOR_ID_FUNCTION = descriptor -> descriptor.getId();
    private static final Key<ParameterizedCachedValue<CssElementDescriptorProvider, PsiElement>> DESCRIPTOR_PROVIDER_KEY = Key.create((String)"css.descriptor.provider");
    private static final ParameterizedCachedValueProvider<CssElementDescriptorProvider, PsiElement> DESCRIPTOR_PROVIDER_CACHE_VALUE = new ParameterizedCachedValueProvider<CssElementDescriptorProvider, PsiElement>(){

        @Nullable
        public CachedValueProvider.Result<CssElementDescriptorProvider> compute(PsiElement param) {
            return CachedValueProvider.Result.create((Object)CssDescriptorsUtil.innerFindDescriptorProvider(param), (Object[])new Object[]{param});
        }
    };

    private CssDescriptorsUtil() {
    }

    @Nullable
    public static CssElementDescriptorProvider findDescriptorProvider(@Nullable PsiElement context) {
        CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssStylesheet.class});
        if (stylesheet != null) {
            return (CssElementDescriptorProvider)CachedValuesManager.getManager((Project)stylesheet.getProject()).getParameterizedCachedValue((UserDataHolder)stylesheet, DESCRIPTOR_PROVIDER_KEY, DESCRIPTOR_PROVIDER_CACHE_VALUE, false, (Object)context);
        }
        return CssDescriptorsUtil.innerFindDescriptorProvider(context);
    }

    private static CssElementDescriptorProvider innerFindDescriptorProvider(PsiElement context) {
        CssElementDescriptorProvider[] providers;
        LinkedList<CssElementDescriptorProvider> applicableProviders = new LinkedList<CssElementDescriptorProvider>();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            if (!provider.isMyContext(context)) continue;
            applicableProviders.add(provider);
            if (!provider.shouldAskOtherProviders(context)) break;
        }
        if (applicableProviders.size() == 1) {
            return (CssElementDescriptorProvider)ContainerUtil.getFirstItem(applicableProviders);
        }
        return !applicableProviders.isEmpty() ? new CompositeCssElementDescriptorProvider(applicableProviders) : null;
    }

    @NotNull
    public static String[] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getSimpleSelectors"));
        }
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        String[] stringArray = provider != null ? provider.getSimpleSelectors(context) : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getSimpleSelectors"));
        }
        return stringArray;
    }

    @Nullable
    public static CssPropertyDescriptor getPropertyDescriptor(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getPropertyDescriptor"));
        }
        return CssDescriptorsUtil.getPropertyDescriptor(declaration.getPropertyName(), declaration);
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.getAllPropertyDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getAllPropertyDescriptors"));
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPseudoSelectorDescriptor> getPseudoSelectorDescriptors(@NotNull String pseudoSelectorName, @Nullable PsiElement context) {
        if (pseudoSelectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudoSelectorName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getPseudoSelectorDescriptors"));
        }
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.findPseudoSelectorDescriptors(pseudoSelectorName, context) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getPseudoSelectorDescriptors"));
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssFunctionDescriptor> getFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getFunctionDescriptors"));
        }
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.findFunctionDescriptors(functionName, context) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getFunctionDescriptors"));
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getPropertyDescriptors(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getPropertyDescriptors"));
        }
        Collection<? extends CssPropertyDescriptor> collection = CssDescriptorsUtil.getPropertyDescriptors(declaration.getPropertyName(), declaration);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getPropertyDescriptors"));
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getPropertyDescriptors"));
        }
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.findPropertyDescriptors(propertyName, context) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getPropertyDescriptors"));
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssMediaFeatureDescriptor> getMediaFeatureDescriptors(@NotNull String featureName, @Nullable PsiElement context) {
        if (featureName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getMediaFeatureDescriptors"));
        }
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.findMediaFeatureDescriptors(featureName, context) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getMediaFeatureDescriptors"));
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.getAllMediaFeatureDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getAllMediaFeatureDescriptors"));
        }
        return collection;
    }

    @Nullable
    public static CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getPropertyDescriptor"));
        }
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        return provider != null ? provider.getPropertyDescriptor(propertyName, context) : null;
    }

    public static boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "isPossibleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "isPossibleSelector"));
        }
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        return provider == null || provider.isPossibleSelector(selector, context);
    }

    @NotNull
    public static Collection<LocalQuickFix> getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName, @NotNull PsiElement context, boolean isOnTheFly) {
        CssElementDescriptorProvider[] providers;
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getQuickFixesForUnknownSimpleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getQuickFixesForUnknownSimpleSelector"));
        }
        HashSet result = ContainerUtil.newHashSet();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            Collections.addAll(result, provider.getQuickFixesForUnknownSimpleSelector(selectorName, context, isOnTheFly));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getQuickFixesForUnknownSimpleSelector"));
        }
        return hashSet;
    }

    @NotNull
    public static Collection<LocalQuickFix> getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
        CssElementDescriptorProvider[] providers;
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getQuickFixesForUnknownProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getQuickFixesForUnknownProperty"));
        }
        HashSet result = ContainerUtil.newHashSet();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            Collections.addAll(result, provider.getQuickFixesForUnknownProperty(propertyName, context, isOnTheFly));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getQuickFixesForUnknownProperty"));
        }
        return hashSet;
    }

    @NotNull
    public static Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.getAllPseudoSelectorDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getAllPseudoSelectorDescriptors"));
        }
        return collection;
    }

    @NotNull
    public static String getCanonicalPropertyName(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getCanonicalPropertyName"));
        }
        String propertyName = declaration.getPropertyName();
        CssPropertyDescriptor descriptor = CssDescriptorsUtil.getPropertyDescriptor(propertyName, declaration);
        String string = descriptor != null ? descriptor.toCanonicalName(propertyName) : propertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "getCanonicalPropertyName"));
        }
        return string;
    }

    @Nullable
    public static <T extends CssElementDescriptor> T getDescriptorFromLatestSpec(Collection<T> descriptors) {
        CssElementDescriptor result = null;
        for (CssElementDescriptor descriptor : descriptors) {
            if (result != null && descriptor.getCssVersion().value() < result.getCssVersion().value()) continue;
            result = descriptor;
        }
        return (T)result;
    }

    @NotNull
    public static String[] extractDescriptorsIdsAsArray(Collection<? extends CssElementDescriptor> descriptors) {
        String[] stringArray = (String[])ContainerUtil.map2Array(descriptors, String.class, GET_DESCRIPTOR_ID_FUNCTION);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "extractDescriptorsIdsAsArray"));
        }
        return stringArray;
    }

    @NotNull
    public static Set<String> extractDescriptorsIds(Collection<? extends CssElementDescriptor> descriptors) {
        Set set = ContainerUtil.map2LinkedSet(descriptors, GET_DESCRIPTOR_ID_FUNCTION);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "extractDescriptorsIds"));
        }
        return set;
    }

    @NotNull
    public static Set<String> extractDocumentations(@NotNull Collection<? extends CssElementDescriptor> descriptors, final @Nullable PsiElement context) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "extractDocumentations"));
        }
        Set set = ContainerUtil.map2LinkedSet(descriptors, (Function)new Function<CssElementDescriptor, String>(){

            public String fun(CssElementDescriptor input) {
                return input.getDocumentationString(context);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "extractDocumentations"));
        }
        return set;
    }

    @NotNull
    public static <T extends CssMediaGroupAwareDescriptor> Collection<T> filterDescriptorsByMediaType(@NotNull Collection<T> descriptors, @Nullable PsiElement context) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "filterDescriptorsByMediaType"));
        }
        Set<CssMediaType> allowedMediaTypes = CssPsiUtil.getAllowedMediaTypesInContext(context);
        if (allowedMediaTypes.contains((Object)CssMediaType.ALL)) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "filterDescriptorsByMediaType"));
            }
            return collection;
        }
        boolean insidePageRule = false;
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
        while (atRule != null) {
            if (atRule.getType() == CssContextType.PAGE || atRule.getType() == CssContextType.PAGE_MARGIN) {
                insidePageRule = true;
                break;
            }
            atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)atRule, CssAtRule.class);
        }
        boolean finalInsidePageRule = insidePageRule;
        List list = ContainerUtil.filter(descriptors, t -> {
            for (CssMediaType mediaType : allowedMediaTypes) {
                CssMediaGroup[] propertyMediaGroups;
                for (CssMediaGroup propertyMediaGroup : propertyMediaGroups = t.getMediaGroups()) {
                    if (propertyMediaGroup != CssMediaGroup.ALL && (!finalInsidePageRule || propertyMediaGroup != CssMediaGroup.PAGED) && !ArrayUtil.contains((Object)((Object)propertyMediaGroup), (Object[])((Object[])mediaType.getSupportedGroups()))) continue;
                    return true;
                }
            }
            return false;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "filterDescriptorsByMediaType"));
        }
        return list;
    }

    @NotNull
    public static <T extends CssElementDescriptor> Collection<T> filterDescriptorsByContext(@NotNull Collection<T> descriptors, @Nullable PsiElement context) {
        CssContextType ruleType;
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "filterDescriptorsByContext"));
        }
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        CssContextType cssContextType = ruleType = provider != null ? provider.getCssContextType(context) : CssContextType.ANY;
        if (ruleType == CssContextType.ANY) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "filterDescriptorsByContext"));
            }
            return collection;
        }
        List list = ContainerUtil.filter(descriptors, input -> input.isAllowedInContextType(ruleType));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "filterDescriptorsByContext"));
        }
        return list;
    }

    public static Collection<CssPseudoSelectorDescriptor> filterPseudoSelectorDescriptorsByColonPrefix(Collection<? extends CssPseudoSelectorDescriptor> descriptors, final int prefixLength) {
        return ContainerUtil.filter(descriptors, (Condition)new Condition<CssPseudoSelectorDescriptor>(){

            public boolean value(CssPseudoSelectorDescriptor input) {
                return input.getColonPrefixLength() == prefixLength;
            }
        });
    }

    @NotNull
    public static <T extends CssElementDescriptor> Collection<T> sortDescriptors(@NotNull Collection<T> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "sortDescriptors"));
        }
        if (descriptors.size() <= 1) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "sortDescriptors"));
            }
            return collection;
        }
        List list = ContainerUtil.sorted(descriptors, (Comparator)new CssVersionDescriptorComparator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil", "sortDescriptors"));
        }
        return list;
    }

    private static class CompositeCssElementDescriptorProvider
    extends CssElementDescriptorProvider {
        private final List<CssElementDescriptorProvider> myProviders;

        public CompositeCssElementDescriptorProvider(List<CssElementDescriptorProvider> providers) {
            this.myProviders = providers;
        }

        @Override
        public boolean isMyContext(@Nullable PsiElement context) {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (!provider.isMyContext(context)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
            if (propertyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getPropertyDescriptor"));
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                CssPropertyDescriptor descriptor = provider.getPropertyDescriptor(propertyName, context);
                if (descriptor == null) continue;
                return descriptor;
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "findPseudoSelectorDescriptors"));
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.findPseudoSelectorDescriptors(name, context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "findPseudoSelectorDescriptors"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getNamedValueDescriptors"));
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.getNamedValueDescriptors(name, parent));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getNamedValueDescriptors"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, PsiElement context) {
            if (propertyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "findPropertyDescriptors"));
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.findPropertyDescriptors(propertyName, context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "findPropertyDescriptors"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
            if (functionName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "findFunctionDescriptors"));
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.findFunctionDescriptors(functionName, context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "findFunctionDescriptors"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssMediaFeatureDescriptor> findMediaFeatureDescriptors(@NotNull String mediaFeatureName, @Nullable PsiElement context) {
            if (mediaFeatureName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaFeatureName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "findMediaFeatureDescriptors"));
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.findMediaFeatureDescriptors(mediaFeatureName, context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "findMediaFeatureDescriptors"));
            }
            return hashSet;
        }

        @Override
        public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "isPossibleSelector"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "isPossibleSelector"));
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (!provider.isPossibleSelector(selector, context)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.getAllPseudoSelectorDescriptors(context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getAllPseudoSelectorDescriptors"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.getAllPropertyDescriptors(context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getAllPropertyDescriptors"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.getAllMediaFeatureDescriptors(context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getAllMediaFeatureDescriptors"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public String[] getSimpleSelectors(@NotNull PsiElement context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getSimpleSelectors"));
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                Collections.addAll(result, provider.getSimpleSelectors(context));
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)result);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getSimpleSelectors"));
            }
            return stringArray;
        }

        @Override
        @NotNull
        public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                PsiElement[] declarations = provider.getDeclarationsForSimpleSelector(selector);
                if (declarations.length == 0) continue;
                if (declarations == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
                }
                return declarations;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
            }
            return PsiElement.EMPTY_ARRAY;
        }

        @Override
        public boolean providesClassicCss() {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (provider.providesClassicCss()) continue;
                return false;
            }
            return true;
        }

        @Override
        @Nullable
        public PsiElement getDocumentationElementForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
            if (selectorName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getDocumentationElementForSelector"));
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                PsiElement element = provider.getDocumentationElementForSelector(selectorName, context);
                if (element == null) continue;
                return element;
            }
            return null;
        }

        @Override
        @Nullable
        public String generateDocForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
            if (selectorName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "generateDocForSelector"));
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                String doc = provider.generateDocForSelector(selectorName, context);
                if (doc == null) continue;
                return doc;
            }
            return null;
        }

        @Override
        @Nullable
        public Color getColorByValue(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getColorByValue"));
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                Color color = provider.getColorByValue(value);
                if (color == null) continue;
                return color;
            }
            return null;
        }

        @Override
        public boolean isColorTerm(@NotNull CssTerm term) {
            if (term == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "isColorTerm"));
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (!provider.isColorTerm(term)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public LocalQuickFix[] getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
            if (propertyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
            }
            HashSet quickFixes = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                Collections.addAll(quickFixes, provider.getQuickFixesForUnknownProperty(propertyName, context, isOnTheFly));
            }
            LocalQuickFix[] localQuickFixArray = quickFixes.toArray(new LocalQuickFix[quickFixes.size()]);
            if (localQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getQuickFixesForUnknownProperty"));
            }
            return localQuickFixArray;
        }

        @Override
        @NotNull
        public LocalQuickFix[] getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName, @NotNull PsiElement context, boolean isOnTheFly) {
            if (selectorName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
            }
            HashSet quickFixes = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                Collections.addAll(quickFixes, provider.getQuickFixesForUnknownSimpleSelector(selectorName, context, isOnTheFly));
            }
            LocalQuickFix[] localQuickFixArray = quickFixes.toArray(new LocalQuickFix[quickFixes.size()]);
            if (localQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getQuickFixesForUnknownSimpleSelector"));
            }
            return localQuickFixArray;
        }

        @Override
        public boolean isColorTermsSupported() {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (provider.isColorTermsSupported()) continue;
                return false;
            }
            return true;
        }

        @Override
        public CssContextType getCssContextType(@Nullable PsiElement context) {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                CssContextType ruleType = provider.getCssContextType(context);
                if (ruleType == CssContextType.ANY) continue;
                return ruleType;
            }
            return CssContextType.ANY;
        }

        @Override
        @NotNull
        public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                PsiReference reference = provider.getStyleReference(element, start, end, caseSensitive);
                if (reference instanceof CssStyleReferenceStub) continue;
                PsiReference psiReference = reference;
                if (psiReference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getStyleReference"));
                }
                return psiReference;
            }
            CssStyleReferenceStub cssStyleReferenceStub = new CssStyleReferenceStub(element, TextRange.create((int)start, (int)end));
            if (cssStyleReferenceStub == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getStyleReference"));
            }
            return cssStyleReferenceStub;
        }

        @Override
        @NotNull
        public CssValueValidator getValueValidator() {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                CssValueValidator validator = provider.getValueValidator();
                if (validator instanceof CssValueValidatorStub) continue;
                CssValueValidator cssValueValidator = validator;
                if (cssValueValidator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getValueValidator"));
                }
                return cssValueValidator;
            }
            CssValueValidator cssValueValidator = super.getValueValidator();
            if (cssValueValidator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider", "getValueValidator"));
            }
            return cssValueValidator;
        }
    }
}

