/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AngularCLIFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    private static final String CREATE = "create ";

    public AngularCLIFilter(Project project, String baseDir) {
        super(project, baseDir);
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/angularjs/cli/AngularCLIFilter", "parse"));
        }
        int index = line.indexOf(CREATE);
        if (index >= 0) {
            int start = index + CREATE.length();
            String fileName = line.substring(start).trim();
            List<FileHyperlinkRawData> list = Collections.singletonList(new FileHyperlinkRawData(fileName, -1, -1, start, start + fileName.length()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIFilter", "parse"));
            }
            return list;
        }
        List<FileHyperlinkRawData> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIFilter", "parse"));
        }
        return list;
    }

    protected boolean supportVfsRefresh() {
        return true;
    }
}

